/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.apexes.commons.lang.Base64;
import net.apexes.commons.lang.Bytes;

public final class Networks {
    private static final HostnameVerifier exemptHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    private Networks() {
    }

    public static String macString() {
        byte[] macBytes = Networks.macBytes();
        if (macBytes == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (byte b : macBytes) {
            buf.append(Bytes.toHex(b));
            buf.append(":");
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }

    public static Long macValue() {
        byte[] macBytes = Networks.macBytes();
        if (macBytes == null) {
            return null;
        }
        byte[] bytes = new byte[8];
        System.arraycopy(macBytes, 0, bytes, 2, 6);
        return Bytes.bytesToLong(bytes);
    }

    public static byte[] macBytes() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                byte[] data;
                NetworkInterface nint = en.nextElement();
                if (nint.isLoopback() || (data = nint.getHardwareAddress()) == null || data.length != 6) continue;
                return data;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static String url(String host, String path) {
        if (host.endsWith("/")) {
            if (path.startsWith("/")) {
                return host + path.substring(1);
            }
        } else if (!path.startsWith("/")) {
            return host + "/" + path;
        }
        return host + path;
    }

    public static HttpURLConnection connect(URL url, SSLContext sslContext, HostnameVerifier hostNameVerifier) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (HttpsURLConnection.class.isInstance(conn)) {
            HttpsURLConnection https = (HttpsURLConnection)HttpsURLConnection.class.cast(conn);
            if (hostNameVerifier != null) {
                https.setHostnameVerifier(hostNameVerifier);
            }
            if (sslContext != null) {
                https.setSSLSocketFactory(sslContext.getSocketFactory());
            }
        }
        return conn;
    }

    public static HttpURLConnection connectExemptSSL(URL url) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        return Networks.connect(url, Networks.exemptSSLContext(), Networks.exemptHostnameVerifier());
    }

    public static SSLContext mutualAuthSSLContext(String trustCert, String keyCert, String keyCertPassword) throws Exception {
        KeyManager[] keyManagers = Networks.certKeyManagers(keyCert, keyCertPassword);
        TrustManager[] trustManagers = Networks.certTrustManagers(trustCert);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    public static SSLContext exemptSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, ExemptVerifyTrustManager.trustManagers, new SecureRandom());
        return context;
    }

    public static HostnameVerifier exemptHostnameVerifier() {
        return exemptHostnameVerifier;
    }

    public static KeyManager[] certKeyManagers(String pemCert, String certPassword) throws Exception {
        byte[] bytes = Base64.decode(pemCert);
        KeyStore keySotre = KeyStore.getInstance("PKCS12");
        keySotre.load(new ByteArrayInputStream(bytes), certPassword.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keySotre, certPassword.toCharArray());
        return kmf.getKeyManagers();
    }

    public static TrustManager[] certTrustManagers(String pemCert) throws Exception {
        byte[] bytes = Base64.decode(pemCert);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bytes));
        String alias = cert.getSubjectX500Principal().getName();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null);
        trustStore.setCertificateEntry(alias, cert);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    public static TrustManager[] exemptTrustManagers() {
        return ExemptVerifyTrustManager.trustManagers;
    }

    private static class ExemptVerifyTrustManager
    implements X509TrustManager {
        static TrustManager[] trustManagers = new TrustManager[]{new ExemptVerifyTrustManager()};
        private static final X509Certificate[] _X509S = new X509Certificate[0];

        private ExemptVerifyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509s, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509s, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return _X509S;
        }
    }
}

