/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.apexes.commons.lang.Radix62;
import net.apexes.commons.lang.Skip32;

public final class Numbers {
    private Numbers() {
    }

    public static BigDecimal trimZero(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return new BigDecimal(Numbers.trimZeroString(value));
    }

    public static String trimZeroString(BigDecimal value) {
        if (value == null) {
            return "";
        }
        String str = value.toPlainString();
        int dotIndex = str.indexOf(46);
        if (dotIndex > 0) {
            int i;
            for (i = str.length() - 1; i > dotIndex && str.charAt(i) == '0'; --i) {
            }
            if (i == dotIndex) {
                --i;
            }
            str = str.substring(0, i + 1);
        }
        return str;
    }

    public static BigDecimal nullToZero(BigDecimal value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    public static boolean eqValue(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            return value2 != null;
        }
        return value2 != null && value1.compareTo(value2) == 0;
    }

    public static long integralPart(BigDecimal value) {
        return value.setScale(0, 3).longValue();
    }

    public static long decimalPart(BigDecimal value) {
        BigDecimal integralPart = value.setScale(0, 3);
        BigDecimal decimal = value.subtract(integralPart);
        return decimal.movePointRight(decimal.scale()).longValue();
    }

    public static int low(int value, int bits) {
        if (bits <= 0) {
            return 0;
        }
        BigDecimal v = BigDecimal.valueOf(value);
        if (v.precision() <= bits) {
            return value;
        }
        v = v.movePointLeft(bits);
        v = v.subtract(BigDecimal.valueOf(v.intValue()));
        v = v.movePointRight(bits);
        return v.intValue();
    }

    public static int high(int value, int bits) {
        if (bits <= 0) {
            return 0;
        }
        BigDecimal v = BigDecimal.valueOf(value);
        int i = v.precision() - bits;
        if (i <= 0) {
            return value;
        }
        return v.movePointLeft(i).intValue();
    }

    public static int bit(BigDecimal value, int bitIndex) {
        if (bitIndex == 0) {
            return 0;
        }
        String str = Numbers.trimZeroString(value.abs());
        int dotIndex = str.indexOf(46);
        int i = bitIndex;
        i = dotIndex > 0 ? dotIndex - bitIndex : str.length() - i;
        if (i < 0 || i >= str.length()) {
            return 0;
        }
        return Integer.valueOf(String.valueOf(str.charAt(i)));
    }

    public static BigDecimal floorOfFive(BigDecimal value, int bitIndex) {
        BigDecimal newValue;
        String str = Numbers.trimZeroString(value.abs());
        int dotIndex = str.indexOf(46);
        if (bitIndex == 0 && dotIndex < 0) {
            return value;
        }
        if (bitIndex == 0) {
            newValue = new BigDecimal(str.substring(0, dotIndex));
        } else {
            char c;
            int i;
            if (dotIndex < 0) {
                dotIndex = str.length();
            }
            if ((i = dotIndex - bitIndex) < 0) {
                return BigDecimal.ZERO;
            }
            if (i >= str.length()) {
                return value;
            }
            StringBuilder buf = new StringBuilder();
            if (i > 0) {
                buf.append(str.substring(0, i));
            }
            if ((c = str.charAt(i)) > '5') {
                buf.append("5");
            } else {
                buf.append("0");
            }
            ++i;
            while (i < dotIndex) {
                buf.append("0");
                ++i;
            }
            newValue = new BigDecimal(buf.toString());
        }
        if (value.signum() < 0) {
            newValue = newValue.negate();
        }
        return Numbers.trimZero(newValue);
    }

    public static List<BigDecimal> floorOfFiveByBitwise(BigDecimal value, int stopBitIndex) {
        ArrayList<BigDecimal> resultList = new ArrayList<BigDecimal>();
        value = Numbers.trimZero(value);
        int scale = value.scale();
        while (scale != 0 && scale >= -stopBitIndex) {
            value = Numbers.floorOfFive(value, -scale);
            resultList.add(value);
            scale = value.scale();
        }
        if (stopBitIndex > 0 && (scale = (value = Numbers.trimZero(value.movePointLeft(stopBitIndex))).scale()) > 0) {
            int bit = Numbers.bit(value, 1);
            while (scale != 0 || bit != 0) {
                value = Numbers.floorOfFive(value, -scale);
                BigDecimal newValue = value.movePointRight(stopBitIndex);
                resultList.add(newValue);
                scale = value.scale();
                bit = Numbers.bit(newValue, 1);
            }
        }
        return resultList;
    }

    public static String toRadix62String(long num) {
        return Radix62.encode(num);
    }

    public static long fromRadix62String(String str) {
        return Radix62.decode(str);
    }

    public static long skip32Encrypt(int value, String key) {
        return Skip32.encrypt(value, key);
    }

    public static int skip32Decrypt(long value, String key) {
        return Skip32.decrypt(value, key);
    }
}

