/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.apexes.commons.lang.Base58;
import net.apexes.commons.lang.Bytes;

public final class Secrets {
    private Secrets() {
    }

    public static byte[] md5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] md5(String text) {
        return Secrets.md5(text, "utf-8");
    }

    public static byte[] md5(String text, String charsetName) {
        try {
            return Secrets.md5(text.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String md5Base58String(byte[] bytes) {
        return Base58.encode(Secrets.md5(bytes));
    }

    public static String md5Base58String(String text) {
        return Base58.encode(Secrets.md5(text));
    }

    public static String md5Base58String(String text, String charsetName) {
        return Base58.encode(Secrets.md5(text, charsetName));
    }

    public static String md5HexString(byte[] bytes) {
        return Bytes.toHex(Secrets.md5(bytes));
    }

    public static String md5HexString(String text) {
        return Bytes.toHex(Secrets.md5(text));
    }

    public static String md5HexString(String text, String charsetName) {
        return Bytes.toHex(Secrets.md5(text, charsetName));
    }

    public static byte[] sha1(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(bytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha1(String text) {
        return Secrets.sha1(text, "utf-8");
    }

    public static byte[] sha1(String text, String charsetName) {
        try {
            return Secrets.sha1(text.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha1HexString(byte[] bytes) {
        return Bytes.toHex(Secrets.sha1(bytes));
    }

    public static String sha1HexString(String text) {
        return Bytes.toHex(Secrets.sha1(text));
    }

    public static String sha1HexString(String text, String charsetName) {
        return Bytes.toHex(Secrets.sha1(text, charsetName));
    }

    public static String sha1Base58String(byte[] bytes) {
        return Base58.encode(Secrets.sha1(bytes));
    }

    public static String sha1Base58String(String text) {
        return Base58.encode(Secrets.sha1(text));
    }

    public static String sha1Base58String(String text, String charsetName) {
        return Base58.encode(Secrets.sha1(text, charsetName));
    }

    public static byte[] encryptByAES(byte[] content, byte[] key) {
        try {
            byte[] encodedKey = Secrets.encodedKeyByAES(key);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, new SecretKeySpec(encodedKey, "AES"));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decryptByAES(byte[] content, byte[] key) {
        try {
            byte[] encodedKey = Secrets.encodedKeyByAES(key);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, new SecretKeySpec(encodedKey, "AES"));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] encodedKeyByAES(byte[] key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(key);
        kgen.init(128, random);
        SecretKey secretKey = kgen.generateKey();
        return secretKey.getEncoded();
    }
}

