/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.text.MessageFormat;
import java.util.Random;
import net.apexes.commons.lang.Radix62;

public final class Strings {
    private Strings() {
    }

    public static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(Radix62.ALPHABET[random.nextInt(Radix62.ALPHABET.length)]);
        }
        return sb.toString();
    }

    public static String randomLetter(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(Radix62.ALPHABET[10 + random.nextInt(Radix62.ALPHABET.length - 10)]);
        }
        return sb.toString();
    }

    public static String randomNumber(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(random.nextInt(10));
        }
        return sb.toString();
    }

    public static String ltrim(String str) {
        int st;
        int len = str.length();
        char[] val = str.toCharArray();
        for (st = 0; st < len && val[st] <= ' '; ++st) {
        }
        return st > 0 ? str.substring(st, len) : str;
    }

    public static String rtrim(String str) {
        int len;
        char[] val = str.toCharArray();
        for (len = str.length(); 0 < len && val[len - 1] <= ' '; --len) {
        }
        return len < str.length() ? str.substring(0, len) : str;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String underscore(String str) {
        if (str == null || str.trim().isEmpty()) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                sb.append("_");
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String camelCase(String str) {
        if (str == null || str.trim().isEmpty()) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '_') {
                if (++i >= len) {
                    sb.append(ch);
                    break;
                }
                sb.append(Character.toUpperCase(str.charAt(i)));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String format(String format, Object ... params) {
        if (params != null) {
            return MessageFormat.format(format.replaceAll("'", "''"), params);
        }
        return format;
    }

    public static String omitString(String str, int length) {
        if (str == null) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        if (str.length() <= length) {
            return str;
        }
        StringBuilder buf1 = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        int i1 = 0;
        int i2 = str.length() - 1;
        length -= 3;
        while (length > 0) {
            char c = str.charAt(i1);
            buf1.append(c);
            ++i1;
            if (--length <= 0) continue;
            c = str.charAt(i2);
            --length;
            buf2.insert(0, c);
            --i2;
        }
        buf1.append("...");
        buf1.append(buf2.toString());
        return buf1.toString();
    }

    public static String stringToHTMLString(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        boolean lastWasBlankChar = false;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastWasBlankChar = true;
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\n') {
                sb.append("&lt;br/&gt;");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(new Integer(ci).toString());
            sb.append(';');
        }
        return sb.toString();
    }

    public static String autoincrementFilename(String filename) {
        String s2;
        String s1;
        String suffix;
        String tmp;
        int m = filename.lastIndexOf(46);
        if (m >= 0) {
            tmp = filename.substring(0, m);
            suffix = filename.substring(m);
        } else {
            tmp = filename;
            suffix = "";
        }
        int n = tmp.lastIndexOf(95);
        if (n >= 0) {
            s1 = tmp.substring(0, n);
            s2 = tmp.substring(n + 1);
        } else {
            s1 = tmp;
            s2 = "";
        }
        int i = 1;
        if (s2.matches("^[1-9]\\d*$")) {
            try {
                i = Integer.valueOf(s2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return s1 + "_" + ++i + suffix;
        }
        if (m != -1) {
            return tmp + "_" + i + suffix;
        }
        return filename + "_" + i;
    }
}

