/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.net;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Networks;

public class HttpFileUploader {
    private static final String boundary = "---------7123a85b75f";
    private final String url;
    private final Map<String, String> httpProperties;
    private final Map<String, String> textParams;
    private final Map<String, FileParameter> fileParams;
    private int connectTimeout = 6000;
    private int readTimeout = 10000;
    private SSLContext sslContext;
    private HostnameVerifier hostNameVerifier;

    public HttpFileUploader(String url) {
        this.url = url;
        this.httpProperties = new LinkedHashMap<String, String>();
        this.textParams = new HashMap<String, String>();
        this.fileParams = new HashMap<String, FileParameter>();
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public void setHttpProperty(String key, String value) {
        Checks.verifyNotNull(key, "key");
        Checks.verifyNotNull(value, "value");
        this.httpProperties.put(key, value);
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.hostNameVerifier = hostNameVerifier;
    }

    public void addTextParameter(String name, String value) {
        this.textParams.put(name, value);
    }

    public void addFileParameter(String name, File file) {
        this.addFileParameter(name, file, "application/octet-stream");
    }

    public void addFileParameter(String name, File file, String contentType) {
        this.fileParams.put(name, new LocalFileParameter(file, contentType));
    }

    public void addFileParameter(String name, byte[] content) {
        this.addFileParameter(name, name, content);
    }

    public void addFileParameter(String name, String filename, byte[] content) {
        this.addFileParameter(name, filename, content, "application/octet-stream");
    }

    public void addFileParameter(String name, byte[] content, String contentType) {
        this.addFileParameter(name, name, content, contentType);
    }

    public void addFileParameter(String name, String filename, byte[] content, String contentType) {
        this.fileParams.put(name, new BytesFileParameter(filename, content, contentType));
    }

    public void clearParameter() {
        this.textParams.clear();
        this.fileParams.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] upload() throws Exception {
        HttpURLConnection conn = Networks.connect(new URL(this.url), this.sslContext, this.hostNameVerifier);
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=---------7123a85b75f");
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        for (Map.Entry<String, String> entry : this.httpProperties.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        conn.connect();
        try {
            int len;
            DataOutputStream ops = new DataOutputStream(conn.getOutputStream());
            this.writeFileParams(ops);
            this.writeTextParams(ops);
            ops.writeBytes("-----------7123a85b75f--\r\n");
            ops.writeBytes("\r\n");
            ops.flush();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = conn.getInputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            conn.disconnect();
        }
    }

    private void writeTextParams(DataOutputStream ops) throws Exception {
        Set<String> keySet = this.textParams.keySet();
        for (String name : keySet) {
            String value = this.textParams.get(name);
            ops.writeBytes("-----------7123a85b75f\r\n");
            ops.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"\r\n");
            ops.writeBytes("\r\n");
            ops.writeBytes(URLEncoder.encode(value, "UTF-8") + "\r\n");
        }
    }

    private void writeFileParams(DataOutputStream ops) throws Exception {
        Set<String> keySet = this.fileParams.keySet();
        for (String name : keySet) {
            FileParameter param = this.fileParams.get(name);
            ops.writeBytes("-----------7123a85b75f\r\n");
            ops.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + URLEncoder.encode(param.getFilename(), "UTF-8") + "\"\r\n");
            ops.writeBytes("Content-Type: " + param.getContentType() + "\r\n");
            ops.writeBytes("\r\n");
            ops.write(param.getContent());
            ops.writeBytes("\r\n");
        }
    }

    private static class BytesFileParameter
    implements FileParameter {
        private final String filename;
        private final byte[] content;
        private final String contentType;

        private BytesFileParameter(String filename, byte[] content, String contentType) {
            this.filename = filename;
            this.content = content;
            this.contentType = contentType;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public byte[] getContent() throws Exception {
            return this.content;
        }
    }

    private static class LocalFileParameter
    implements FileParameter {
        private final File file;
        private final String contentType;

        private LocalFileParameter(File file, String contentType) {
            this.file = file;
            this.contentType = contentType;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getFilename() {
            return this.file.getName();
        }

        @Override
        public byte[] getContent() throws Exception {
            int len;
            FileInputStream in = new FileInputStream(this.file);
            ByteArrayOutputStream ops = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                ops.write(buf, 0, len);
            }
            in.close();
            return ops.toByteArray();
        }
    }

    public static interface FileParameter {
        public String getContentType();

        public String getFilename();

        public byte[] getContent() throws Exception;
    }
}

