/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.net;

import java.net.URLEncoder;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.net.StringHttpClient;

public class NameValuePairPoster {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final StringHttpClient client;

    public NameValuePairPoster(String url) {
        this.client = new StringHttpClient(url, CONTENT_TYPE);
    }

    public NameValuePairPoster setConnectTimeout(int timeout) {
        this.client.setConnectTimeout(timeout);
        return this;
    }

    public NameValuePairPoster setReadTimeout(int timeout) {
        this.client.setReadTimeout(timeout);
        return this;
    }

    public NameValuePairPoster setSslContext(SSLContext sslContext) {
        this.client.setSslContext(sslContext);
        return this;
    }

    public NameValuePairPoster setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.client.setHostNameVerifier(hostNameVerifier);
        return this;
    }

    public NameValuePairPoster setHttpProperty(String key, String value) {
        this.client.setHttpProperty(key, value);
        return this;
    }

    public NameValuePairPoster setRequestLogger(StringHttpClient.CallLogger requestLogger) {
        this.client.setRequestLogger(requestLogger);
        return this;
    }

    public NameValuePairPoster setResponseLogger(StringHttpClient.CallLogger responseLogger) {
        this.client.setResponseLogger(responseLogger);
        return this;
    }

    public NameValuePairPoster setRequestEncoder(StringHttpClient.RequestEncoder requestEncoder) {
        this.client.setRequestEncoder(requestEncoder);
        return this;
    }

    public NameValuePairPoster setResponseReader(StringHttpClient.ResponseReader responseReader) {
        this.client.setResponseReader(responseReader);
        return this;
    }

    public String post(Map<String, String> request) throws Exception {
        return this.post(request, "utf-8");
    }

    public String post(Map<String, String> request, String enc) throws Exception {
        Checks.verifyNotNull(request, "request");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : request.entrySet()) {
            String key = URLEncoder.encode(entry.getKey(), enc);
            String value = URLEncoder.encode(entry.getValue(), enc);
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(key);
            if (value == null) continue;
            sb.append('=');
            sb.append(value);
        }
        return this.client.doPost(sb.toString());
    }

    public static NameValuePairPoster forRequest(String url) {
        return new NameValuePairPoster(url);
    }
}

