/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.net;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Networks;
import net.apexes.commons.net.ResponseException;

public class StringHttpClient {
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json; charset=utf-8";
    public static final String CONTENT_TYPE_APPLICATION_OCTETSTREAM = "application/octet-stream";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    public static final String PROPERTY_CONTENT_ENCODING = "Content-Encoding";
    public static final String PROPERTY_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String PROPERTY_CONNECTION = "Connection";
    public static final String PROPERTY_CONTENT_TYPE = "Content-Type";
    public static final String CONNECTION_CLOSE = "close";
    public static final String GZIP = "gzip";
    private static final RequestEncoder DEFAULT_REQUEST_ENCODER = new SimpleRequestEncoder();
    private final String url;
    private final String contentType;
    private final Map<String, String> httpProperties;
    private int connectTimeout = 3000;
    private int readTimeout = 180000;
    private boolean acceptCompress;
    private SSLContext sslContext;
    private HostnameVerifier hostNameVerifier;
    private CallLogger requestLogger;
    private CallLogger responseLogger;
    private RequestEncoder requestEncoder;
    private ResponseReader responseReader;

    public StringHttpClient(String url) {
        this(url, CONTENT_TYPE_APPLICATION_JSON);
    }

    public StringHttpClient(String url, String contentType) {
        Checks.verifyNotNull(url, "url");
        Checks.verifyNotNull(contentType, "contentType");
        this.url = url;
        this.contentType = contentType;
        this.httpProperties = new LinkedHashMap<String, String>();
    }

    public boolean isAcceptCompress() {
        return this.acceptCompress;
    }

    public StringHttpClient setAcceptCompress(boolean value) {
        this.acceptCompress = value;
        return this;
    }

    public StringHttpClient setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public StringHttpClient setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public StringHttpClient setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public StringHttpClient setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.hostNameVerifier = hostNameVerifier;
        return this;
    }

    public StringHttpClient exemptSSL() throws KeyManagementException, NoSuchAlgorithmException {
        this.sslContext = Networks.exemptSSLContext();
        this.hostNameVerifier = Networks.exemptHostnameVerifier();
        return this;
    }

    public StringHttpClient setHttpProperty(String key, String value) {
        Checks.verifyNotNull(key, "key");
        Checks.verifyNotNull(value, "value");
        this.httpProperties.put(key, value);
        return this;
    }

    public StringHttpClient setRequestLogger(CallLogger requestLogger) {
        this.requestLogger = requestLogger;
        return this;
    }

    public StringHttpClient setResponseLogger(CallLogger responseLogger) {
        this.responseLogger = responseLogger;
        return this;
    }

    public StringHttpClient setRequestEncoder(RequestEncoder requestEncoder) {
        this.requestEncoder = requestEncoder;
        return this;
    }

    public StringHttpClient setResponseReader(ResponseReader responseReader) {
        this.responseReader = responseReader;
        return this;
    }

    public String doPost(String request) throws Exception {
        return this.doPost(request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String request, boolean compress) throws Exception {
        byte[] body = this.requestEncoder != null ? this.requestEncoder.encode(this, request, compress) : DEFAULT_REQUEST_ENCODER.encode(this, request, compress);
        HttpURLConnection conn = this.openConnection(METHOD_POST, new URL(this.url), compress);
        try {
            if (this.requestLogger != null) {
                this.requestLogger.log(request);
            }
            if (body != null) {
                conn.getOutputStream().write(body);
                conn.getOutputStream().close();
            }
            String string = this.handleResponse(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public String doGet() throws Exception {
        HttpURLConnection conn = this.openConnection(METHOD_GET, new URL(this.url), false);
        try {
            if (this.requestLogger != null) {
                this.requestLogger.log(this.url);
            }
            conn.connect();
            String string = this.handleResponse(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private String handleResponse(HttpURLConnection conn) throws Exception {
        if (conn.getResponseCode() != 200) {
            throw new ResponseException(conn.getResponseCode(), conn.getResponseMessage());
        }
        InputStream ips = GZIP.equalsIgnoreCase(conn.getHeaderField(PROPERTY_CONTENT_ENCODING)) ? new GZIPInputStream(conn.getInputStream()) : conn.getInputStream();
        if (this.responseReader == null) {
            this.responseReader = new SimpleResponseReader();
        }
        String responseJson = this.responseReader.read(ips);
        if (this.responseLogger != null) {
            this.responseLogger.log(responseJson);
        }
        return responseJson;
    }

    protected HttpURLConnection openConnection(String method, URL url, boolean compress) throws Exception {
        HttpURLConnection conn = Networks.connect(url, this.sslContext, this.hostNameVerifier);
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty(PROPERTY_CONNECTION, CONNECTION_CLOSE);
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        if (compress) {
            conn.setRequestProperty(PROPERTY_CONTENT_ENCODING, GZIP);
            conn.setRequestProperty(PROPERTY_CONTENT_TYPE, CONTENT_TYPE_APPLICATION_OCTETSTREAM);
        } else {
            conn.setRequestProperty(PROPERTY_CONTENT_TYPE, this.contentType);
        }
        if (this.acceptCompress) {
            conn.setRequestProperty(PROPERTY_ACCEPT_ENCODING, GZIP);
        }
        for (Map.Entry<String, String> entry : this.httpProperties.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return conn;
    }

    public static StringHttpClient forRequest(String url) {
        return new StringHttpClient(url);
    }

    public static interface CallLogger {
        public void log(String var1);
    }

    public static interface ResponseReader {
        public String read(InputStream var1) throws Exception;
    }

    public static class SimpleResponseReader
    implements ResponseReader {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String read(InputStream ips) throws Exception {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(ips, "utf-8"));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                String string = sb.toString();
                return string;
            }
        }
    }

    public static class SimpleRequestEncoder
    implements RequestEncoder {
        @Override
        public byte[] encode(StringHttpClient client, String request, boolean compress) throws Exception {
            if (request == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (compress) {
                GZIPOutputStream gzipOut = new GZIPOutputStream(out);
                gzipOut.write(request.getBytes("utf-8"));
                gzipOut.finish();
                gzipOut.close();
            } else {
                out.write(request.getBytes("utf-8"));
            }
            return out.toByteArray();
        }
    }

    public static interface RequestEncoder {
        public byte[] encode(StringHttpClient var1, String var2, boolean var3) throws Exception;
    }
}

