/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;

/**
 * @author <a href=mailto:hedyn@foxmail.com>HeDYn</a>
 */
public final class Streams {
    private Streams() {}

    public static void transfer(File sourceFile, OutputStream targetOs, boolean snapshoot) throws Exception {
        byte[] buf = new byte[10 * 1024];
        long fileLen = sourceFile.length();
        long outLen = 0;
        try (FileInputStream fis = new FileInputStream(sourceFile)) {
            int len;
            while ((len = fis.read(buf)) != -1) {
                targetOs.write(buf, 0, len);
                if (snapshoot) {
                    outLen += len;
                    if (outLen >= fileLen) {
                        break;
                    }
                }
            }
        }
    }

}
