/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.apexes.commons.i18n.EnumMsg;
import net.apexes.commons.i18n.I18nMsg;
import net.apexes.commons.i18n.I18nResource;
import net.apexes.commons.lang.Checks;

public class I18Ns {
    private static final Map<String, String> CURRENCY_SYMBOL = new HashMap<String, String>();

    public static String currencySymbol(String currencyCode) {
        String symbol = CURRENCY_SYMBOL.get(currencyCode);
        return symbol == null ? "$" : symbol;
    }

    public static Locale toLocale(String localeStr) {
        Checks.verifyNotEmpty(localeStr, "localeStr");
        int idx = localeStr.indexOf(95);
        if (idx == -1) {
            return new Locale(localeStr);
        }
        String language = localeStr.substring(0, idx);
        String country = localeStr.substring(idx + 1);
        return new Locale(language.toLowerCase(), country.toUpperCase());
    }

    public static I18nMsg msg(String bundleName, Locale locale) {
        return new I18nMsg(I18Ns.i18nResource(bundleName, locale));
    }

    public static I18nMsg msg(String bundleName, Locale locale, I18nMsg.Logger logger) {
        return new I18nMsg(I18Ns.i18nResource(bundleName, locale), logger);
    }

    public static EnumMsg enumMsg(String bundleName, Locale locale) {
        return new EnumMsg(I18Ns.i18nResource(bundleName, locale));
    }

    public static EnumMsg enumMsg(String bundleName, Locale locale, I18nMsg.Logger logger) {
        return new EnumMsg(I18Ns.i18nResource(bundleName, locale), logger);
    }

    public static I18nResource i18nResource(String bundleName, Locale locale) {
        return new I18nResourceBundle(bundleName, locale);
    }

    static {
        CURRENCY_SYMBOL.put("CNY", "\u00a5");
        CURRENCY_SYMBOL.put("EUR", "\u20ac");
        CURRENCY_SYMBOL.put("GBP", "\u00a3");
        CURRENCY_SYMBOL.put("JPY", "\u00a5");
        CURRENCY_SYMBOL.put("KRW", "\u20a9");
        CURRENCY_SYMBOL.put("VND", "\u20ab");
        CURRENCY_SYMBOL.put("LAK", "\u20ad");
        CURRENCY_SYMBOL.put("PHP", "\u20b1");
        CURRENCY_SYMBOL.put("THB", "\u0e3f");
        CURRENCY_SYMBOL.put("KHR", "\u17db");
    }

    private static class I18nResourceBundle
    implements I18nResource {
        private ResourceBundle resourceBundle;

        private I18nResourceBundle(String bundleName, Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                this.resourceBundle = ResourceBundle.getBundle(bundleName, locale);
            }
            catch (Exception e) {
                this.resourceBundle = ResourceBundle.getBundle(bundleName);
            }
        }

        @Override
        public Locale getLocale() {
            return this.resourceBundle.getLocale();
        }

        @Override
        public boolean containsKey(String key) {
            return this.resourceBundle.containsKey(key);
        }

        @Override
        public String getString(String key) {
            return this.resourceBundle.getString(key);
        }
    }
}

