/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.NamedThreadFactory;

public class AsyncExecutor<E> {
    private static final int MAX_CAP = Short.MAX_VALUE;
    private final int queueCapacity;
    private final int parallelism;
    private final Worker<E> worker;
    private final ErrorMonitor errorMonitor;
    private final ThreadFactory threadFactory;
    private volatile boolean running = false;
    private volatile boolean closing = false;
    private BlockingQueue<E> queue;
    private ExecutorService executorService;

    public static Builder builder() {
        return new Builder();
    }

    public AsyncExecutor(Worker<E> worker) {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), worker);
    }

    public AsyncExecutor(int parallelism, Worker<E> worker) {
        this(Integer.MAX_VALUE, parallelism, worker);
    }

    public AsyncExecutor(int queueCapacity, int parallelism, Worker<E> worker) {
        this(queueCapacity, parallelism, worker, null);
    }

    public AsyncExecutor(int queueCapacity, int parallelism, Worker<E> worker, ErrorMonitor monitor) {
        this(queueCapacity, parallelism, worker, monitor, null);
    }

    public AsyncExecutor(int queueCapacity, int parallelism, Worker<E> worker, ErrorMonitor monitor, ThreadFactory threadFactory) {
        Checks.verifyNotNull(worker, "worker");
        this.queueCapacity = this.checkQueueCapacity(queueCapacity);
        this.parallelism = this.checkParallelism(parallelism);
        this.worker = worker;
        this.errorMonitor = monitor;
        this.threadFactory = threadFactory == null ? new NamedThreadFactory("async", "worker") : threadFactory;
    }

    private int checkQueueCapacity(int queueCapacity) {
        if (queueCapacity <= 0) {
            throw new IllegalArgumentException("queueCapacity = " + queueCapacity);
        }
        return queueCapacity;
    }

    private int checkParallelism(int parallelism) {
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException("parallelism = " + parallelism);
        }
        return parallelism;
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("already running.");
        }
        this.closing = false;
        this.running = true;
        this.queue = new LinkedBlockingQueue(this.queueCapacity);
        this.executorService = Executors.newFixedThreadPool(this.parallelism, this.threadFactory);
        for (int i = 0; i < this.parallelism; ++i) {
            this.executorService.execute(new Task());
        }
    }

    public synchronized void close() {
        this.closing = true;
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        if (this.queue != null) {
            this.queue.clear();
        }
        this.running = false;
    }

    public boolean offer(E data) {
        if (this.closing) {
            throw new IllegalStateException("already closing.");
        }
        return this.queue.offer(data);
    }

    public boolean offer(E data, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.closing) {
            throw new IllegalStateException("already closing.");
        }
        return this.queue.offer(data, timeout, unit);
    }

    public int getQueueSize() {
        if (this.queue == null) {
            return 0;
        }
        return this.queue.size();
    }

    public boolean isActivated() {
        return this.running && !this.closing;
    }

    public static interface ErrorMonitor {
        public void onError(Exception var1);
    }

    public static interface Worker<E> {
        public void execute(E var1);
    }

    private class Task
    implements Runnable {
        private Task() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    do {
                        this.execute(AsyncExecutor.this.queue.take());
                    } while (!AsyncExecutor.this.closing);
                }
                catch (InterruptedException e) {
                    if (AsyncExecutor.this.closing) break;
                    if (AsyncExecutor.this.errorMonitor == null) continue;
                    AsyncExecutor.this.errorMonitor.onError(e);
                    continue;
                }
                break;
            }
        }

        private void execute(E data) {
            block2: {
                try {
                    AsyncExecutor.this.worker.execute(data);
                }
                catch (Exception e) {
                    if (AsyncExecutor.this.errorMonitor == null) break block2;
                    AsyncExecutor.this.errorMonitor.onError(e);
                }
            }
        }
    }

    public static class Builder {
        private int queueCapacity;
        private int parallelism;
        private ErrorMonitor errorMonitor;
        private ThreadFactory threadFactory;

        private Builder() {
        }

        public Builder queueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Builder parallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder errorMonitor(ErrorMonitor errorMonitor) {
            this.errorMonitor = errorMonitor;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public <E> AsyncExecutor<E> build(Worker<E> worker) {
            return new AsyncExecutor<E>(this.queueCapacity, this.parallelism, worker, this.errorMonitor, this.threadFactory);
        }
    }
}

