/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import net.apexes.commons.lang.Bytes;
import net.apexes.commons.lang.IDs;
import net.apexes.commons.lang.Networks;
import net.apexes.commons.lang.ProcessIdentifier;

public class IDGenerator {
    private final byte[] idedBytes;
    private static final AtomicLong lastTime = new AtomicLong(Long.MIN_VALUE);
    private static final Ided ided = new Ided();

    private IDGenerator(byte[] idedBytes) {
        this.idedBytes = idedBytes;
    }

    public String gen() {
        return IDGenerator.genId(this.idedBytes);
    }

    static String genId() {
        return IDGenerator.genId(ided.systemIdedBytes());
    }

    static String genId(byte[] idedBytes) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(IDGenerator.timeMillis());
        buf.put(idedBytes);
        return IDs.toBase58Id(buf.array());
    }

    private static long timeMillis() {
        long timeMillis;
        block2: {
            long current;
            timeMillis = System.currentTimeMillis();
            timeMillis <<= 13;
            while (true) {
                if (timeMillis > (current = lastTime.get())) {
                    if (!lastTime.compareAndSet(current, timeMillis)) continue;
                    break block2;
                }
                if (lastTime.compareAndSet(current, current + 1L)) break;
            }
            timeMillis = current + 1L;
        }
        return timeMillis;
    }

    static IDGenerator namespace(long namespace) {
        return IDGenerator.namespace(Bytes.longToBytes(namespace));
    }

    static IDGenerator namespace(byte[] namespaceBytes) {
        byte[] idedBytes = new byte[8];
        if (namespaceBytes.length > 0) {
            int len = Math.min(namespaceBytes.length, 6);
            int srcPos = namespaceBytes.length - len;
            int destPos = 6 - len;
            System.arraycopy(namespaceBytes, srcPos, idedBytes, destPos, len);
        }
        idedBytes[6] = ided.pidBytes()[0];
        idedBytes[7] = ided.pidBytes()[1];
        return new IDGenerator(idedBytes);
    }

    private static class Ided {
        private volatile short pid;
        private volatile byte[] PID_BYTES;
        private volatile byte[] SYSTEM_IDED_BYTES;

        private Ided() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        byte[] pidBytes() {
            if (this.PID_BYTES != null) return this.PID_BYTES;
            Class<Ided> clazz = Ided.class;
            synchronized (Ided.class) {
                if (this.PID_BYTES != null) return this.PID_BYTES;
                this.init();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.PID_BYTES;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        byte[] systemIdedBytes() {
            if (this.SYSTEM_IDED_BYTES != null) return this.SYSTEM_IDED_BYTES;
            Class<Ided> clazz = Ided.class;
            synchronized (Ided.class) {
                if (this.SYSTEM_IDED_BYTES != null) return this.SYSTEM_IDED_BYTES;
                this.init();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.SYSTEM_IDED_BYTES;
            }
        }

        private void init() {
            int i;
            this.pid = ProcessIdentifier.Impl.processId();
            this.PID_BYTES = Bytes.shortToBytes(this.pid);
            Long macValue = Networks.macValue();
            if (macValue == null) {
                try {
                    byte[] localBytes = InetAddress.getLocalHost().getAddress();
                    int localValue = Bytes.bytesToInt(localBytes);
                    macValue = localValue;
                    macValue = macValue << 8;
                }
                catch (Exception e) {
                    Random random = new Random(System.currentTimeMillis());
                    macValue = random.nextLong();
                }
            }
            BitSet bitSet = new BitSet(64);
            long m = 1L;
            for (i = 0; i < 16; ++i) {
                if (((long)this.pid & m) != 0L) {
                    bitSet.set(i * 4);
                }
                m <<= 1;
            }
            m = 1L;
            for (i = 0; i < 48; ++i) {
                if ((macValue & m) != 0L) {
                    bitSet.set(i + i / 3 + 1);
                }
                m <<= 1;
            }
            this.SYSTEM_IDED_BYTES = bitSet.toByteArray();
        }
    }
}

