/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;

public class DynamicClassLoader
extends URLClassLoader {
    public DynamicClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
    }

    public void addFile(Path file) {
        this.addFile(file.toFile());
    }

    public void addFile(File file) {
        if (file.exists()) {
            try {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files != null) {
                        for (File f : files) {
                            if (!f.exists() || !f.isFile()) continue;
                            this.addURL(f.toURI().toURL());
                        }
                    }
                } else if (file.isFile()) {
                    this.addURL(file.toURI().toURL());
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void addClassPath(String classPath) {
        String[] filenames;
        if (classPath == null || classPath.isEmpty()) {
            return;
        }
        String separator = System.getProperty("path.separator");
        for (String filename : filenames = classPath.split(separator)) {
            if (filename == null || filename.isEmpty()) continue;
            this.addFile(new File(filename));
        }
    }

    public Object newInstance(String className) throws Exception {
        Class<?> clazz = this.loadClass(className);
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

