/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Comparators;

public abstract class Enume<T extends Comparable<T>>
implements Comparable<Enume<T>> {
    private final T value;
    private final int ordinal;
    private String name;
    private boolean defineEnume;
    private static final EnumeCache enumeCache = new EnumeCache();

    private Enume(T value) {
        Class<?> classType = this.getClass();
        if (Enume.findConstructor(classType) == null) {
            throw new InstantiationError("Invalid enume. [" + this.getClass().getName() + ", " + value + "]");
        }
        this.value = value;
        this.ordinal = enumeCache.add(this);
        this.defineEnume = true;
    }

    public final T value() {
        return this.value;
    }

    public final int ordinal() {
        if (this.defineEnume) {
            return this.ordinal;
        }
        return -1;
    }

    public final String name() {
        if (this.defineEnume) {
            if (this.name == null) {
                Field[] fields;
                Class<?> enumeClass = this.getClass();
                for (Field field : fields = enumeClass.getFields()) {
                    if (!Enume.isEnumeField(enumeClass, field)) continue;
                    try {
                        if (field.get(enumeClass) != this) continue;
                        this.name = field.getName();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return this.name;
        }
        return null;
    }

    public final String fullName() {
        String name = this.name();
        if (name != null) {
            return this.getClass().getSimpleName() + "." + name;
        }
        return null;
    }

    public final boolean eqValue(T value) {
        return Enume.eqValue(this, value);
    }

    public final boolean neValue(T value) {
        return !Enume.eqValue(this, value);
    }

    public final boolean isDefine() {
        return this.defineEnume;
    }

    public final boolean isUnknown() {
        return !this.isDefine();
    }

    private void unknownEnume() {
        this.defineEnume = false;
    }

    private void defineEnume(String name) {
        this.defineEnume = true;
        this.name = name;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Enume other = (Enume)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    @Override
    public final int compareTo(Enume<T> o) {
        if (this.value == null) {
            if (o.value == null) {
                return 0;
            }
            return -1;
        }
        if (o.value == null) {
            return 1;
        }
        return this.value.compareTo(o.value);
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> boolean eqValue(E enume, T value) {
        return Enume.equalsValue(enume, value);
    }

    private static boolean equalsValue(Enume<?> enume, Object value) {
        Checks.verifyNotNull(enume, "enume");
        if (value == null) {
            return enume.value() == null;
        }
        Object enumeValue = enume.value();
        return enumeValue != null && enumeValue.equals(value);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> boolean eq(E enume1, E enume2) {
        if (enume1 == null) {
            return enume2 == null;
        }
        return enume1.equals(enume2);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> T toValue(E enume) {
        return enume == null ? null : (T)enume.value();
    }

    public static <T extends Comparable<T>, E extends Enume<T>> E fromValue(Class<E> enumeClass, T value) {
        return (E)((Enume)Enume.cast(Enume.valueOf(enumeClass, value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enume<?> valueOf(Class<? extends Enume<?>> enumeClass, Object value) {
        Enume.verifyClass(enumeClass);
        EnumeCache enumeCache = Enume.enumeCache;
        synchronized (enumeCache) {
            Enume<?> enume = Enume.enumeCache.getOne(enumeClass, value);
            if (enume == null) {
                enume = Enume.newEnume(enumeClass, value);
                super.unknownEnume();
            }
            return enume;
        }
    }

    public static <T extends Comparable<T>, E extends Enume<T>> int compare(E enum1, E enum2) {
        return Enume.compare(enum1, enum2, false);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> int compareNullLast(E enum1, E enum2) {
        return Enume.compare(enum1, enum2, true);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> int compare(E enum1, E enum2, boolean nullLast) {
        return Comparators.compareNull(enum1, enum2, nullLast);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> int ordinalCompare(E enum1, E enum2) {
        return Enume.ordinalCompare(enum1, enum2, false);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> int ordinalCompareNullLast(E enum1, E enum2) {
        return Enume.ordinalCompare(enum1, enum2, true);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> int ordinalCompare(E enum1, E enum2, boolean nullLast) {
        int v = Comparators.xorCompare(enum1, enum2, nullLast);
        if (v == 0 && enum1 != null && enum2 != null) {
            return Integer.compare(enum1.ordinal(), enum2.ordinal());
        }
        return v;
    }

    public static <T extends Comparable<T>, E extends Enume<T>> boolean isDefine(Class<E> enumeClass, T value) {
        for (Enume enume : Enume.values(enumeClass)) {
            if (!enume.eqValue(value)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>, E extends Enume<T>> boolean isUnknown(Class<E> enumeClass, T value) {
        return !Enume.isDefine(enumeClass, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>, E extends Enume<T>> Collection<E> values(Class<E> enumeClass) {
        Enume.verifyEnumeClass(enumeClass);
        EnumeCache enumeCache = Enume.enumeCache;
        synchronized (enumeCache) {
            Set<Enume<?>> set = Enume.enumeCache.getAllDefind(enumeClass);
            if (set == null) {
                return Collections.emptyList();
            }
            return (Collection)Enume.cast(Collections.unmodifiableCollection(set));
        }
    }

    public static <T extends Comparable<T>, E extends Enume<T>> void verifyEnumeClass(Class<E> enumeClass) {
        Enume.verifyClass(enumeClass);
    }

    private static void verifyClass(Class<? extends Enume<?>> enumeClass) {
        Checks.verifyNotNull(enumeClass, "enumeClass");
        if (enumeClass.getSuperclass() != This.class) {
            throw new IllegalArgumentException("Superclass must be Enumerate. [" + enumeClass.getName() + "]");
        }
        if (Enume.findValueClass(enumeClass) == null) {
            throw new IllegalArgumentException("Superclass must has actual type arguments. [" + enumeClass.getName() + "]");
        }
    }

    public static Class<? extends Comparable<?>> valueClass(Class<?> classType) {
        if (classType != null && Enume.class.isAssignableFrom(classType)) {
            return Enume.findValueClass(classType);
        }
        return null;
    }

    private static Class<? extends Comparable<?>> findValueClass(Class<?> classType) {
        try {
            Type[] types;
            ParameterizedType paramType;
            Type type = classType.getGenericSuperclass();
            if (type instanceof ParameterizedType && This.class.equals((Object)(paramType = (ParameterizedType)type).getRawType()) && (types = paramType.getActualTypeArguments())[1] == classType) {
                return (Class)Enume.cast(types[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Constructor<? extends Enume<?>> findConstructor(Class<? extends Enume<?>> enumeClass) {
        Constructor<? extends Enume<?>> constructor = null;
        Class<Comparable<? extends Enume<?>>> valueClass = Enume.findValueClass(enumeClass);
        if (valueClass != null) {
            try {
                constructor = enumeClass.getDeclaredConstructor(valueClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return constructor;
    }

    private static Enume<?> newEnume(Class<? extends Enume<?>> enumeClass, Object value) {
        Exception exception = null;
        try {
            Constructor<Enume<?>> constructor = Enume.findConstructor(enumeClass);
            if (constructor != null) {
                constructor.setAccessible(true);
                return constructor.newInstance(value);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        throw new RuntimeException("Invalid Enume. [" + enumeClass.getName() + ", " + value + "]", exception);
    }

    private static boolean isEnumeField(Class<?> enumeClass, Field field) {
        int m = field.getModifiers();
        return field.getType() == enumeClass && Modifier.isPublic(m) && Modifier.isStatic(m) && Modifier.isFinal(m);
    }

    private static <T> T cast(Object value) {
        return (T)value;
    }

    static void printCache(PrintStream printStream) {
        printStream.println(enumeCache);
    }

    /* synthetic */ Enume(Comparable x0, 1 x1) {
        this(x0);
    }

    private static class EnumeCache {
        private final Map<Class<?>, EnumesHolder> enumsFinder = new HashMap();

        private EnumeCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int add(Enume<?> enume) {
            Map<Class<?>, EnumesHolder> map = this.enumsFinder;
            synchronized (map) {
                Class<?> enumeClass = enume.getClass();
                EnumesHolder holder = (EnumesHolder)Enume.cast(this.enumsFinder.get(enumeClass));
                if (holder == null) {
                    holder = new EnumesHolder();
                    this.enumsFinder.put(enumeClass, holder);
                }
                int ordinal = holder.size();
                holder.add(enume);
                return ordinal;
            }
        }

        Set<Enume<?>> getAllDefind(Class<? extends Enume<?>> enumeClass) {
            EnumesHolder holder = this.findHolder(enumeClass);
            if (holder != null) {
                return holder.defindSet;
            }
            return null;
        }

        Enume<?> getOne(Class<? extends Enume<?>> enumeClass, Object value) {
            Enume<?> enume = null;
            EnumesHolder holder = this.findHolder(enumeClass);
            if (holder != null) {
                enume = holder.find(value);
            }
            return enume;
        }

        private EnumesHolder findHolder(Class<? extends Enume<?>> enumeClass) {
            EnumesHolder holder = (EnumesHolder)Enume.cast(this.enumsFinder.get(enumeClass));
            if (holder == null) {
                Field[] fields;
                LinkedHashSet definds = new LinkedHashSet();
                for (Field field : fields = enumeClass.getFields()) {
                    if (!Enume.isEnumeField(enumeClass, field)) continue;
                    try {
                        Enume e = (Enume)Enume.cast(field.get(enumeClass));
                        e.defineEnume(field.getName());
                        definds.add(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                holder = (EnumesHolder)Enume.cast(this.enumsFinder.get(enumeClass));
                holder.completeDefind(definds);
            } else if (holder.defindSet == null) {
                TreeSet definds = new TreeSet(new Comparator<Enume<?>>(){

                    @Override
                    public int compare(Enume<?> o1, Enume<?> o2) {
                        return Comparators.compare(o1.ordinal(), o2.ordinal());
                    }
                });
                for (Enume e : holder.keySet()) {
                    if (!e.isDefine()) continue;
                    definds.add(e);
                }
                holder.completeDefind(definds);
            }
            return holder;
        }

        public String toString() {
            return "EnumeCache [" + this.enumsFinder + "]";
        }
    }

    public static abstract class This<T extends Comparable<T>, E extends This<T, E>>
    extends Enume<T> {
        protected This(T value) {
            super((Comparable)value, null);
        }

        public final boolean eq(E enume) {
            return this.equals(enume);
        }

        public final boolean ne(E enume) {
            return !this.eq(enume);
        }
    }

    private static class EnumesHolder
    extends WeakHashMap<Enume<?>, Object> {
        private Set<Enume<?>> defindSet;

        private EnumesHolder() {
        }

        void completeDefind(Set<Enume<?>> defindSet) {
            this.defindSet = defindSet;
        }

        void add(Enume<?> enume) {
            Enume<?> e = this.find(enume.value());
            if (e != null) {
                throw new RuntimeException("The util already exists. [" + e.getClass() + ", " + e.value() + "]");
            }
            this.put(enume, null);
        }

        Enume<?> find(Object value) {
            for (Enume e : this.keySet()) {
                if (!Enume.equalsValue(e, value)) continue;
                return e;
            }
            return null;
        }

        @Override
        public String toString() {
            LinkedHashMap<Enume, String> map = new LinkedHashMap<Enume, String>();
            for (Enume enume : this.keySet()) {
                map.put(enume, enume.name());
            }
            return ((Object)map).toString();
        }
    }
}

