/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import net.apexes.commons.lang.Bytes;
import net.apexes.commons.lang.IDs;
import net.apexes.commons.lang.Networks;
import net.apexes.commons.lang.ProcessIdentifier;

public class IDGenerator {
    private final byte[] idedBytes;
    private static final AtomicLong LAST_TIME = new AtomicLong(Long.MIN_VALUE);
    private static final Ided IDED = new Ided();

    private IDGenerator(byte[] idedBytes) {
        this.idedBytes = idedBytes;
    }

    public String gen() {
        return IDGenerator.genId(this.idedBytes);
    }

    static String genId() {
        return IDGenerator.genId(IDED.systemIdedBytes());
    }

    static String genId(byte[] idedBytes) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(IDGenerator.timeMillis());
        buf.put(idedBytes);
        return IDs.toBase58Id(buf.array());
    }

    private static long timeMillis() {
        long timeMillis;
        block2: {
            long current;
            timeMillis = System.currentTimeMillis();
            timeMillis <<= 13;
            while (true) {
                if (timeMillis > (current = LAST_TIME.get())) {
                    if (!LAST_TIME.compareAndSet(current, timeMillis)) continue;
                    break block2;
                }
                if (LAST_TIME.compareAndSet(current, current + 1L)) break;
            }
            timeMillis = current + 1L;
        }
        return timeMillis;
    }

    static IDGenerator namespace(long namespace) {
        return new IDGenerator(Bytes.longToBytes(namespace));
    }

    static IDGenerator namespace(int major, short minor) {
        byte[] majorBytes = Bytes.intToBytes(major);
        byte[] minorBytes = Bytes.shortToBytes(minor);
        byte[] pidBytes = IDED.pidBytes();
        byte[] namespaceBytes = new byte[]{pidBytes[0], pidBytes[1], minorBytes[0], minorBytes[1], majorBytes[0], majorBytes[1], majorBytes[2], majorBytes[3]};
        return new IDGenerator(namespaceBytes);
    }

    private static class Ided {
        private volatile byte[] pidBytes;
        private volatile byte[] systemIdedBytes;

        private Ided() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        byte[] pidBytes() {
            if (this.pidBytes != null) return this.pidBytes;
            Class<Ided> clazz = Ided.class;
            synchronized (Ided.class) {
                if (this.pidBytes != null) return this.pidBytes;
                this.init();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.pidBytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        byte[] systemIdedBytes() {
            if (this.systemIdedBytes != null) return this.systemIdedBytes;
            Class<Ided> clazz = Ided.class;
            synchronized (Ided.class) {
                if (this.systemIdedBytes != null) return this.systemIdedBytes;
                this.init();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.systemIdedBytes;
            }
        }

        private void init() {
            int i;
            short pid = ProcessIdentifier.Impl.processId();
            Long macValue = Networks.macValue();
            if (macValue == null) {
                try {
                    byte[] localBytes = InetAddress.getLocalHost().getAddress();
                    int localValue = Bytes.bytesToInt(localBytes);
                    macValue = localValue;
                    macValue = macValue << 8;
                }
                catch (Exception e) {
                    Random random = new Random(System.currentTimeMillis());
                    macValue = random.nextLong();
                }
            }
            BitSet bitSet = new BitSet(64);
            long m = 1L;
            for (i = 0; i < 16; ++i) {
                if (((long)pid & m) != 0L) {
                    bitSet.set(i * 4);
                }
                m <<= 1;
            }
            m = 1L;
            for (i = 0; i < 48; ++i) {
                if ((macValue & m) != 0L) {
                    bitSet.set(i + i / 3 + 1);
                }
                m <<= 1;
            }
            this.systemIdedBytes = bitSet.toByteArray();
            this.pidBytes = Bytes.shortToBytes(pid);
        }
    }
}

