/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.apexes.commons.lang.Base58;
import net.apexes.commons.lang.Bytes;

public class Passwords {
    private static final PasswordHelper defaultHelper = new PasswordHelper();

    public static String digest(String password) {
        return Passwords.digest(password.toCharArray());
    }

    public static String digest(char[] password) {
        return Bytes.toHex(defaultHelper.digest(password));
    }

    public static boolean validate(String password, String digest) {
        return Passwords.validate(password.toCharArray(), digest);
    }

    public static boolean validate(char[] password, String digest) {
        return defaultHelper.validate(password, Bytes.fromHex(digest));
    }

    public static String digestBase58(String password) {
        return Passwords.digestBase58(password.toCharArray());
    }

    public static String digestBase58(char[] password) {
        return Base58.encode(defaultHelper.digest(password));
    }

    public static boolean validateBase58(String password, String digest) {
        return Passwords.validateBase58(password.toCharArray(), digest);
    }

    public static boolean validateBase58(char[] password, String digest) {
        return defaultHelper.validate(password, Base58.decode(digest));
    }

    public static PasswordDigester digester() {
        return new PasswordHelper();
    }

    public static PasswordValidater validater() {
        return new PasswordHelper();
    }

    private static class PasswordHelper
    implements PasswordDigester,
    PasswordValidater {
        private int saltLength = 8;
        private int keyLength = 8;
        private int iterationCount = 99;

        private PasswordHelper() {
        }

        @Override
        public PasswordHelper saltLength(int saltLength) {
            this.saltLength = saltLength;
            return this;
        }

        @Override
        public PasswordHelper keyLength(int keyLength) {
            this.keyLength = keyLength;
            return this;
        }

        @Override
        public PasswordHelper iterationCount(int iterationCount) {
            this.iterationCount = iterationCount;
            return this;
        }

        @Override
        public byte[] digest(char[] password) {
            try {
                return this.pbkdf2(password, this.saltLength, this.keyLength, this.iterationCount);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean validate(char[] password, byte[] digest) {
            byte[] salt = Arrays.copyOfRange(digest, 0, this.saltLength);
            byte[] hash = Arrays.copyOfRange(digest, this.saltLength, this.saltLength + this.keyLength);
            byte[] testHash = this.pbkdf2(password, salt, this.iterationCount, hash.length);
            return this.slowEquals(hash, testHash);
        }

        private byte[] pbkdf2(char[] password, int saltLength, int keyLength, int iterationCount) {
            SecureRandom random = new SecureRandom();
            byte[] salt = new byte[saltLength];
            random.nextBytes(salt);
            byte[] hash = this.pbkdf2(password, salt, iterationCount, keyLength);
            byte[] bytes = new byte[saltLength + keyLength];
            System.arraycopy(salt, 0, bytes, 0, saltLength);
            System.arraycopy(hash, 0, bytes, saltLength, keyLength);
            return bytes;
        }

        private byte[] pbkdf2(char[] password, byte[] salt, int iterations, int keyLength) {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, keyLength * 8);
            try {
                SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                return skf.generateSecret(spec).getEncoded();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean slowEquals(byte[] arr1, byte[] arr2) {
            int diff = arr1.length ^ arr2.length;
            for (int i = 0; i < arr1.length && i < arr2.length; ++i) {
                diff |= arr1[i] ^ arr2[i];
            }
            return diff == 0;
        }
    }

    public static interface PasswordValidater {
        public PasswordValidater saltLength(int var1);

        public PasswordValidater keyLength(int var1);

        public PasswordValidater iterationCount(int var1);

        public boolean validate(char[] var1, byte[] var2);
    }

    public static interface PasswordDigester {
        public PasswordDigester saltLength(int var1);

        public PasswordDigester keyLength(int var1);

        public PasswordDigester iterationCount(int var1);

        public byte[] digest(char[] var1);
    }
}

