/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Streams;

public final class Zips {
    public static void unzip(Path zipFile, Path descDir) throws Exception {
        Zips.unzip(zipFile, descDir, false);
    }

    public static void unzipSafeOverwrite(Path zipFile, Path descDir) throws Exception {
        Zips.unzip(zipFile, descDir, true);
    }

    public static void unzip(Path zipFile, Path descDir, boolean safeOverwrite) throws Exception {
        if (Files.notExists(descDir, new LinkOption[0])) {
            Files.createDirectory(descDir, new FileAttribute[0]);
        }
        byte[] buf = new byte[8192];
        try (ZipFile zip = new ZipFile(zipFile.toFile());){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                Path destFile = descDir.resolve(zipEntryName);
                Path destFileParentDir = destFile.getParent();
                if (Files.notExists(destFileParentDir, new LinkOption[0])) {
                    Files.createDirectory(destFileParentDir, new FileAttribute[0]);
                }
                if (Files.isDirectory(destFile, new LinkOption[0])) continue;
                if (safeOverwrite) {
                    Path tempDestFile = descDir.resolve(zipEntryName + ".temp");
                    try (InputStream is = zip.getInputStream(entry);
                         OutputStream os = Files.newOutputStream(tempDestFile, new OpenOption[0]);){
                        int len;
                        while ((len = is.read(buf)) > 0) {
                            os.write(buf, 0, len);
                        }
                    }
                    try {
                        Files.move(tempDestFile, destFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (Exception e) {
                        Files.delete(tempDestFile);
                        throw e;
                    }
                }
                InputStream is = zip.getInputStream(entry);
                try {
                    OutputStream os = Files.newOutputStream(destFile, new OpenOption[0]);
                    try {
                        int len;
                        while ((len = is.read(buf)) > 0) {
                            os.write(buf, 0, len);
                        }
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    public static ZipCompress keepStructure() {
        return new ZipCompressImpl(true);
    }

    public static ZipCompress notStructure() {
        return new ZipCompressImpl(true);
    }

    private static class ZipCompressImpl
    implements ZipCompress {
        private final boolean keepStructure;
        private final Map<File, String> fileMap;
        private boolean snapshoot;

        private ZipCompressImpl(boolean keepStructure) {
            this.keepStructure = keepStructure;
            this.fileMap = new LinkedHashMap<File, String>();
        }

        @Override
        public ZipCompress snapshoot() {
            this.snapshoot = true;
            return this;
        }

        @Override
        public ZipCompress addFile(String name, File file) {
            this.fileMap.put(file, name);
            return this;
        }

        @Override
        public ZipCompress addFile(File ... files) {
            Checks.verifyNotEmpty(files, "files");
            return this.addFiles(Arrays.asList(files));
        }

        @Override
        public ZipCompress addFiles(List<File> files) {
            Checks.verifyNotEmpty(files, "files");
            for (File file : files) {
                this.fileMap.put(file, file.getName());
            }
            return this;
        }

        @Override
        public void compress(OutputStream out) throws Exception {
            try (ZipOutputStream zos = new ZipOutputStream(out);){
                for (Map.Entry<File, String> entry : this.fileMap.entrySet()) {
                    File file = entry.getKey();
                    String name = entry.getValue();
                    if (!file.exists()) continue;
                    ZipCompressImpl.doCompress(file, zos, name, this.keepStructure, this.snapshoot);
                }
                zos.finish();
            }
        }

        private static void doCompress(File sourceFile, ZipOutputStream zos, String name, boolean keepStructure, boolean snapshoot) throws Exception {
            if (sourceFile.isFile()) {
                zos.putNextEntry(new ZipEntry(name));
                Streams.transfer(sourceFile, (OutputStream)zos, snapshoot);
                zos.closeEntry();
            } else if (sourceFile.isDirectory()) {
                File[] listFiles = sourceFile.listFiles();
                if (listFiles == null || listFiles.length == 0) {
                    if (keepStructure) {
                        zos.putNextEntry(new ZipEntry(name + "/"));
                        zos.closeEntry();
                    }
                } else {
                    for (File file : listFiles) {
                        if (keepStructure) {
                            ZipCompressImpl.doCompress(file, zos, name + "/" + file.getName(), keepStructure, snapshoot);
                            continue;
                        }
                        ZipCompressImpl.doCompress(file, zos, file.getName(), keepStructure, snapshoot);
                    }
                }
            }
        }
    }

    public static interface ZipCompress {
        public ZipCompress snapshoot();

        public ZipCompress addFile(String var1, File var2);

        public ZipCompress addFile(File ... var1);

        public ZipCompress addFiles(List<File> var1);

        public void compress(OutputStream var1) throws Exception;
    }
}

