/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.net;

import java.net.SocketException;
import net.apexes.commons.lang.Checks;

public class ResponseException
extends SocketException {
    private static final long serialVersionUID = 1L;
    private final int responseCode;
    private final String responseMessage;
    private final String errorMessage;

    public ResponseException(int responseCode, String responseMessage) {
        this(responseCode, responseMessage, null);
    }

    public ResponseException(int responseCode, String responseMessage, String errorMessage) {
        super(ResponseException.message(responseCode, responseMessage, errorMessage));
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.errorMessage = errorMessage;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private static String message(int responseCode, String responseMessage, String errorMessage) {
        StringBuilder message = new StringBuilder().append(responseCode).append(" ").append(responseMessage);
        if (Checks.isNotEmpty(errorMessage)) {
            String lineSeparator = System.getProperty("line.separator");
            message.append(lineSeparator).append(errorMessage);
        }
        return message.toString();
    }
}

