/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.net;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Networks;
import net.apexes.commons.lang.Streams;
import net.apexes.commons.net.ResponseException;

public class StringHttpClient {
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_APPLICATION_OCTETSTREAM = "application/octet-stream";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    public static final String PROPERTY_CONTENT_ENCODING = "Content-Encoding";
    public static final String PROPERTY_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String PROPERTY_CONNECTION = "Connection";
    public static final String PROPERTY_CONTENT_TYPE = "Content-Type";
    public static final String PROPERTY_CONTENT_LEN = "Content-Length";
    public static final String CONNECTION_KEEP_ALIVE = "Keep-Alive";
    public static final String GZIP = "gzip";
    private static final RequestEncoder DEFAULT_REQUEST_ENCODER = new SimpleRequestEncoder();
    private final String url;
    private final Map<String, String> httpProperties;
    private final String contentType;
    private String charset;
    private int connectTimeout = 3000;
    private int readTimeout = 180000;
    private boolean acceptCompress;
    private SSLContext sslContext;
    private HostnameVerifier hostNameVerifier;
    private CallLogger requestLogger;
    private CallLogger responseLogger;
    private RequestEncoder requestEncoder;
    private ResponseReader responseReader;

    public StringHttpClient(String url) {
        this(url, CONTENT_TYPE_APPLICATION_JSON);
    }

    public StringHttpClient(String url, String contentType) {
        Checks.verifyNotNull(url, "url");
        Checks.verifyNotNull(contentType, "contentType");
        this.url = url;
        this.contentType = contentType;
        this.httpProperties = new LinkedHashMap<String, String>();
    }

    public String getCharset() {
        if (this.charset == null) {
            return "UTF-8";
        }
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isAcceptCompress() {
        return this.acceptCompress;
    }

    public StringHttpClient setAcceptCompress(boolean value) {
        this.acceptCompress = value;
        return this;
    }

    public StringHttpClient setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public StringHttpClient setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public StringHttpClient setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public StringHttpClient setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.hostNameVerifier = hostNameVerifier;
        return this;
    }

    public StringHttpClient exemptSSL() throws KeyManagementException, NoSuchAlgorithmException {
        this.sslContext = Networks.exemptSSLContext();
        this.hostNameVerifier = Networks.exemptHostnameVerifier();
        return this;
    }

    public StringHttpClient setHttpProperty(String key, String value) {
        Checks.verifyNotNull(key, "key");
        Checks.verifyNotNull(value, "value");
        this.httpProperties.put(key, value);
        return this;
    }

    public String getHttpProperty(String key) {
        Checks.verifyNotNull(key, "key");
        return this.httpProperties.get(key);
    }

    public StringHttpClient setRequestLogger(CallLogger requestLogger) {
        this.requestLogger = requestLogger;
        return this;
    }

    public StringHttpClient setResponseLogger(CallLogger responseLogger) {
        this.responseLogger = responseLogger;
        return this;
    }

    public StringHttpClient setRequestEncoder(RequestEncoder requestEncoder) {
        this.requestEncoder = requestEncoder;
        return this;
    }

    public StringHttpClient setResponseReader(ResponseReader responseReader) {
        this.responseReader = responseReader;
        return this;
    }

    public String doPost(String request) throws Exception {
        return this.doPost(request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String request, boolean compress) throws Exception {
        byte[] body = this.requestEncoder != null ? this.requestEncoder.encode(this, request, compress) : DEFAULT_REQUEST_ENCODER.encode(this, request, compress);
        HttpURLConnection conn = this.openConnection(METHOD_POST, new URL(this.url), compress);
        try {
            if (this.requestLogger != null) {
                this.requestLogger.log(this.requestHeader(), this.url, request);
            }
            if (body != null) {
                conn.getOutputStream().write(body);
            } else {
                conn.setRequestProperty(PROPERTY_CONTENT_LEN, "0");
            }
            conn.getOutputStream().flush();
            conn.getOutputStream().close();
            String string = this.handleResponse(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    public String doGet() throws Exception {
        HttpURLConnection conn = this.openConnection(METHOD_GET, new URL(this.url), false);
        try {
            if (this.requestLogger != null) {
                this.requestLogger.log(this.requestHeader(), this.url, null);
            }
            conn.connect();
            String string = this.handleResponse(conn);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private String handleResponse(HttpURLConnection conn) throws Exception {
        int code = conn.getResponseCode();
        if (code != 200) {
            InputStream is;
            String message = conn.getResponseMessage();
            StringBuilder error = new StringBuilder();
            if (code >= 400 && (is = conn.getErrorStream()) != null) {
                String line;
                String lineSeparator = System.getProperty("line.separator");
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, this.getCharset()));
                boolean first = true;
                while ((line = reader.readLine()) != null) {
                    if (first) {
                        first = false;
                    } else {
                        error.append(lineSeparator);
                    }
                    error.append(line);
                }
            }
            if (error.length() > 0) {
                throw new ResponseException(code, message, error.toString());
            }
            throw new ResponseException(code, message);
        }
        InputStream ips = GZIP.equalsIgnoreCase(conn.getHeaderField(PROPERTY_CONTENT_ENCODING)) ? new GZIPInputStream(conn.getInputStream()) : conn.getInputStream();
        if (this.responseReader == null) {
            this.responseReader = new SimpleResponseReader();
        }
        String responseJson = this.responseReader.read(ips);
        if (this.responseLogger != null) {
            this.responseLogger.log(this.responseHeader(conn), this.url, responseJson);
        }
        return responseJson;
    }

    protected HttpURLConnection openConnection(String method, URL url, boolean compress) throws Exception {
        HttpURLConnection conn = Networks.connect(url, this.sslContext, this.hostNameVerifier);
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        conn.setRequestProperty(PROPERTY_CONNECTION, CONNECTION_KEEP_ALIVE);
        if (compress) {
            conn.setRequestProperty(PROPERTY_CONTENT_ENCODING, GZIP);
            conn.setRequestProperty(PROPERTY_CONTENT_TYPE, CONTENT_TYPE_APPLICATION_OCTETSTREAM);
        } else {
            conn.setRequestProperty(PROPERTY_CONTENT_TYPE, this.contentType + "; charset=" + this.getCharset());
        }
        if (this.acceptCompress) {
            conn.setRequestProperty(PROPERTY_ACCEPT_ENCODING, GZIP);
        }
        for (Map.Entry<String, String> entry : this.httpProperties.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return conn;
    }

    private Header requestHeader() {
        return new Header(){

            @Override
            public String get(String key) {
                return (String)StringHttpClient.this.httpProperties.get(key);
            }
        };
    }

    private Header responseHeader(final HttpURLConnection conn) {
        return new Header(){

            @Override
            public String get(String key) {
                return conn.getHeaderField(key);
            }
        };
    }

    public static StringHttpClient forRequest(String url) {
        return new StringHttpClient(url);
    }

    public static interface CallLogger {
        public void log(Header var1, String var2, String var3);
    }

    public static interface RequestEncoder {
        public byte[] encode(StringHttpClient var1, String var2, boolean var3) throws Exception;
    }

    public static interface ResponseReader {
        public String read(InputStream var1) throws Exception;
    }

    public static interface Header {
        public String get(String var1);
    }

    public static class SimpleResponseReader
    implements ResponseReader {
        @Override
        public String read(InputStream is) throws Exception {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Streams.transfer(is, os);
            return new String(os.toByteArray(), StandardCharsets.UTF_8);
        }
    }

    public static class SimpleRequestEncoder
    implements RequestEncoder {
        @Override
        public byte[] encode(StringHttpClient client, String request, boolean compress) throws Exception {
            if (request == null) {
                return null;
            }
            String charset = client.getCharset();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (compress) {
                GZIPOutputStream gzipOut = new GZIPOutputStream(out);
                gzipOut.write(request.getBytes(charset));
                gzipOut.finish();
                gzipOut.close();
            } else {
                out.write(request.getBytes(charset));
            }
            return out.toByteArray();
        }
    }
}

