/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import net.apexes.commons.xml.XmlElement;

public final class Xmls {
    private Xmls() {
    }

    public static XmlElement node(XmlElement xml, String path) {
        String[] nodes;
        String start;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.startsWith(start = "/" + xml.getName() + "/")) {
            return null;
        }
        path = path.replaceFirst(start, "");
        for (String node : nodes = path.split("/")) {
            if ((xml = xml.getChild(node)) != null) continue;
            return null;
        }
        return xml;
    }

    public static String nodeContent(XmlElement xml, String path) {
        if ((xml = Xmls.node(xml, path)) == null) {
            return null;
        }
        return xml.getContent();
    }

    public static String nodeAttr(XmlElement xml, String path, String name) {
        if ((xml = Xmls.node(xml, path)) == null) {
            return null;
        }
        return xml.getStringAttribute(name);
    }

    public static String nodeAttr(XmlElement xml, String path, String name, String defaultValue) {
        if ((xml = Xmls.node(xml, path)) == null) {
            return null;
        }
        return xml.getStringAttribute(name, defaultValue);
    }

    public static XmlElement xml(String xml) {
        XmlElement x = new XmlElement();
        x.parseString(xml);
        return x;
    }

    public static XmlElement xml(File xmlFile, Charset charset) throws IOException {
        return Xmls.xml(xmlFile, charset.name());
    }

    public static XmlElement xml(File xmlFile, String charsetName) throws IOException {
        try (FileInputStream in = null;){
            in = new FileInputStream(xmlFile);
            XmlElement xmlElement = Xmls.xml((InputStream)in, charsetName);
            return xmlElement;
        }
    }

    public static XmlElement xml(InputStream input, Charset charset) throws IOException {
        return Xmls.xml(input, charset.name());
    }

    public static XmlElement xml(InputStream input, String charsetName) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, charsetName);
        return Xmls.xml(reader);
    }

    public static XmlElement xml(Reader reader) throws IOException {
        XmlElement xml = new XmlElement(true);
        xml.parseFromReader(reader);
        return xml;
    }

    public static void save(XmlElement xml, File xmlFile, Charset charset) throws IOException {
        Xmls.save(xml, xmlFile, charset.name());
    }

    public static void save(XmlElement xml, File xmlFile, String charsetName) throws IOException {
        try (Writer writer = null;){
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), charsetName);
            xml.write(writer, true, 4);
            writer.flush();
        }
    }
}

