/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.i18n;

import java.util.Enumeration;
import java.util.Locale;
import net.apexes.commons.i18n.I18nMsg;
import net.apexes.commons.i18n.I18nResource;
import net.apexes.commons.lang.Enume;

public final class EnumMsg {
    private final I18nMsg msg;

    public EnumMsg(I18nResource resource) {
        this.msg = new I18nMsg(resource);
    }

    public EnumMsg(I18nResource resource, I18nMsg.Logger logger) {
        this.msg = new I18nMsg(resource, logger);
    }

    public Locale getLocale() {
        return this.msg.getLocale();
    }

    public Enumeration<String> getKeys() {
        return this.msg.getKeys();
    }

    public boolean containsKey(String key) {
        return this.msg.containsKey(key);
    }

    public String getMessage(String key) {
        return this.msg.getMessage(key, key);
    }

    public String getMessage(String key, String defaultValue) {
        return this.msg.getMessage(key, defaultValue);
    }

    public String formatKey(String key, Object ... params) {
        return this.msg.formatKey(key, params);
    }

    public String getEnumName(Enum<?> theEnum) {
        if (theEnum == null) {
            return null;
        }
        return this.getEnumName((Enume)((Object)theEnum), theEnum.name());
    }

    public String getEnumName(Enum<?> theEnum, String defaultValue) {
        return this.msg.getMessage(EnumMsg.getEnumKey(theEnum), defaultValue);
    }

    public <T extends Enume<?>> String getEnumName(T theEnume) {
        if (theEnume == null) {
            return null;
        }
        return this.getEnumName(theEnume, EnumMsg.enumNameOrValue(theEnume));
    }

    public <T extends Enume<?>> String getEnumName(T theEnume, String defaultValue) {
        return this.msg.getMessage(EnumMsg.getEnumKey(theEnume), defaultValue);
    }

    public static String getEnumKey(Enum<?> theEnum) {
        Class<?> enumClass = theEnum.getClass();
        if (enumClass.isMemberClass()) {
            return enumClass.getDeclaringClass().getSimpleName() + "." + enumClass.getSimpleName() + "." + theEnum.name();
        }
        return enumClass.getSimpleName() + "." + theEnum.name();
    }

    public static <T extends Enume<?>> String getEnumKey(T theEnume) {
        Class<?> enumClass = theEnume.getClass();
        String enumeName = EnumMsg.enumNameOrValue(theEnume);
        if (enumClass.isMemberClass()) {
            return enumClass.getDeclaringClass().getSimpleName() + "." + enumClass.getSimpleName() + "." + enumeName;
        }
        return enumClass.getSimpleName() + "." + enumeName;
    }

    private static <T extends Enume<?>> String enumNameOrValue(T theEnume) {
        String enumeName = theEnume.name();
        if (enumeName == null) {
            enumeName = String.valueOf(theEnume.value());
        }
        return enumeName;
    }
}

