/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.i18n;

import java.util.Enumeration;
import java.util.Locale;
import net.apexes.commons.i18n.I18nResource;
import net.apexes.commons.lang.Strings;

public class I18nMsg {
    protected final Logger logger;
    protected final I18nResource resource;

    public I18nMsg(I18nResource resource) {
        this(resource, new IgnoreLogger());
    }

    public I18nMsg(I18nResource resource, Logger logger) {
        this.resource = resource;
        this.logger = logger;
    }

    public Locale getLocale() {
        return this.resource.getLocale();
    }

    public Enumeration<String> getKeys() {
        return this.resource.getKeys();
    }

    public boolean containsKey(String key) {
        return this.resource.containsKey(key);
    }

    public String getMessage(String key) {
        return this.getMessage(key, key);
    }

    public String getMessage(String key, String defaultValue) {
        if (key == null) {
            this.logger.logNotFoundKey(this.resource.getLocale(), key);
            return defaultValue;
        }
        if (this.containsKey(key)) {
            return this.resource.getString(key);
        }
        this.logger.logNotFoundKey(this.resource.getLocale(), key);
        return defaultValue;
    }

    public String formatKey(String key, Object ... params) {
        return this.format(this.getMessage(key), params);
    }

    private String format(String fmt, Object ... params) {
        try {
            return Strings.format(fmt, params);
        }
        catch (Exception e) {
            this.logger.logFormatError(this.resource.getLocale(), e, fmt, params);
            return fmt;
        }
    }

    private static class IgnoreLogger
    implements Logger {
        private IgnoreLogger() {
        }

        @Override
        public void logNotFoundKey(Locale locale, String key) {
        }

        @Override
        public void logFormatError(Locale locale, Exception e, String format, Object ... params) {
        }
    }

    public static interface Logger {
        public void logNotFoundKey(Locale var1, String var2);

        public void logFormatError(Locale var1, Exception var2, String var3, Object ... var4);
    }
}

