/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.ByteArrayOutputStream;

public class Base62 {
    private static final char[] encodes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final byte[] decodes = new byte[256];

    private Base62() {
    }

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        int pos = 0;
        int val = 0;
        for (byte datum : bytes) {
            val = val << 8 | datum & 0xFF;
            pos += 8;
            while (pos > 5) {
                char c = encodes[val >> (pos -= 6)];
                sb.append(c == 'i' ? "ia" : (c == '+' ? "ib" : (c == '/' ? "ic" : Character.valueOf(c))));
                val &= (1 << pos) - 1;
            }
        }
        if (pos > 0) {
            char c = encodes[val << 6 - pos];
            sb.append(c == 'i' ? "ia" : (c == '+' ? "ib" : (c == '/' ? "ic" : Character.valueOf(c))));
        }
        return sb.toString();
    }

    public static byte[] decode(String base62) {
        if (base62 == null) {
            return null;
        }
        char[] data = base62.toCharArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(base62.toCharArray().length);
        int pos = 0;
        int val = 0;
        for (int i = 0; i < data.length; ++i) {
            int c = data[i];
            if (c == 105) {
                c = (c = data[++i]) == 97 ? 105 : (c == 98 ? 43 : (c == 99 ? 47 : data[--i]));
            }
            val = val << 6 | decodes[c];
            pos += 6;
            while (pos > 7) {
                baos.write(val >> (pos -= 8));
                val &= (1 << pos) - 1;
            }
        }
        return baos.toByteArray();
    }

    static {
        for (int i = 0; i < encodes.length; ++i) {
            Base62.decodes[Base62.encodes[i]] = (byte)i;
        }
    }
}

