/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import net.apexes.commons.lang.IDs;

public final class Bytes {
    private Bytes() {
    }

    public static int bytesToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value <<= 8;
            value |= bytes[i] & 0xFF;
        }
        return value;
    }

    public static byte[] intToBytes(int value) {
        byte[] targets = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = 32 - (i + 1) * 8;
            targets[i] = (byte)(value >> offset & 0xFF);
        }
        return targets;
    }

    public static long bytesToLong(byte[] bytes) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value <<= 8;
            value |= (long)(bytes[i] & 0xFF);
        }
        return value;
    }

    public static byte[] longToBytes(long value) {
        byte[] targets = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int offset = 64 - (i + 1) * 8;
            targets[i] = (byte)(value >> offset & 0xFFL);
        }
        return targets;
    }

    public static short bytesToShort(byte[] bytes) {
        int value = (bytes[0] < 0 ? bytes[0] + 256 : bytes[0]) << 8;
        return (short)(value += bytes[1] < 0 ? bytes[1] + 256 : bytes[1]);
    }

    public static byte[] shortToBytes(short value) {
        byte[] bytes = new byte[]{(byte)((value & 0xFF00) >> 8), (byte)(value & 0xFF)};
        return bytes;
    }

    public static byte[] fromHex(String hex) {
        byte[] arrB = hex.getBytes();
        int iLen = arrB.length;
        byte[] arrOut = new byte[iLen / 2];
        for (int i = 0; i < iLen; i += 2) {
            String strTmp = new String(arrB, i, 2);
            arrOut[i / 2] = (byte)Integer.parseInt(strTmp, 16);
        }
        return arrOut;
    }

    public static String toHex(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            int i = b & 0xFF;
            if (i < 16) {
                builder.append("0");
            }
            builder.append(Integer.toHexString(i));
        }
        return builder.toString();
    }

    public static String toHex(byte value) {
        int i = value & 0xFF;
        String hex = Integer.toHexString(i);
        if (i >= 16) {
            return hex;
        }
        return "0" + hex;
    }

    public static String hexFormat(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            int i = b & 0xFF;
            if (i < 16) {
                builder.append("0");
            }
            builder.append(Integer.toHexString(i));
            builder.append(" ");
        }
        return builder.toString();
    }

    public static byte[] hexParse(String hex) {
        byte[] arrB = hex.getBytes();
        int iLen = arrB.length;
        byte[] arrOut = new byte[iLen / 2];
        for (int i = 0; i < iLen; ++i) {
            if (arrB[i] == 32) continue;
            String strTmp = new String(arrB, i, 2);
            arrOut[i / 2] = (byte)Integer.parseInt(strTmp, 16);
            ++i;
        }
        return arrOut;
    }

    public static byte[] reverse(byte[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        byte[] ary = new byte[array.length];
        int i = 0;
        for (int j = array.length - 1; j >= 0; --j) {
            ary[i] = array[j];
            ++i;
        }
        return ary;
    }

    public static String toBase58Id(byte[] bytes) {
        return IDs.toBase58Id(bytes);
    }

    public static byte[] fromBase58Id(String base58Id) {
        return IDs.fromBase58Id(base58Id);
    }
}

