/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.apexes.commons.lang.MurmurHash;

public class ConsistenthashHelper {
    private final int virtualCount;
    private final SortedMap<Integer, String> virtualNodes;
    private final Set<String> sourceNodes;

    public ConsistenthashHelper() {
        this(200);
    }

    public ConsistenthashHelper(int virtualCount) {
        this.virtualCount = virtualCount;
        this.virtualNodes = new TreeMap<Integer, String>();
        this.sourceNodes = new HashSet<String>();
    }

    public boolean isEmpty() {
        return this.sourceNodes.isEmpty();
    }

    public synchronized void clear() {
        this.sourceNodes.clear();
        this.virtualNodes.clear();
    }

    public synchronized Set<String> nodesSnapshoot() {
        return new HashSet<String>(this.sourceNodes);
    }

    public synchronized void add(String node) {
        if (!this.sourceNodes.contains(node)) {
            this.sourceNodes.add(node);
            for (int i = 0; i < this.virtualCount; ++i) {
                this.virtualNodes.put(this.hash(node, i), node);
            }
        }
    }

    public synchronized void remove(String node) {
        this.sourceNodes.remove(node);
        for (int i = 0; i < this.virtualCount; ++i) {
            this.virtualNodes.remove(this.hash(node, i));
        }
    }

    public synchronized String get(String key) {
        if (this.virtualNodes.isEmpty()) {
            return null;
        }
        int hash = this.hashcode(key);
        String target = (String)this.virtualNodes.get(hash);
        if (target == null) {
            SortedMap<Integer, String> subMap = this.virtualNodes.tailMap(hash);
            hash = subMap.isEmpty() ? this.virtualNodes.firstKey().intValue() : subMap.firstKey().intValue();
            target = (String)this.virtualNodes.get(hash);
        }
        return target;
    }

    private int hash(String node, int index) {
        String name = node + "&&VN" + String.valueOf(index);
        return this.hashcode(name);
    }

    private int hashcode(String key) {
        return MurmurHash.hash32(key);
    }
}

