/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public class NTPTimeMillis {
    public static final int DEFAULT_PORT = 123;
    static final int DEFAULT_TIMEOUT_MS = 3000;
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_VERSION = 3;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;

    public static long requestTime(InetAddress address) throws Exception {
        return NTPTimeMillis.requestTime(address, 123, 3000);
    }

    public static long requestTime(InetAddress address, int port, int timeout) throws Exception {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(timeout);
            byte[] buffer = new byte[48];
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, port);
            buffer[0] = 27;
            long requestTime = System.currentTimeMillis();
            long requestTicks = System.nanoTime();
            NTPTimeMillis.writeTimeStamp(buffer, requestTime);
            socket.send(request);
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);
            long responseTicks = System.nanoTime();
            long responseTime = requestTime + TimeUnit.NANOSECONDS.toMillis(responseTicks - requestTicks);
            long originateTime = NTPTimeMillis.readTimeStamp(buffer, 24);
            long receiveTime = NTPTimeMillis.readTimeStamp(buffer, 32);
            long transmitTime = NTPTimeMillis.readTimeStamp(buffer, 40);
            long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
            long l = responseTime + clockOffset;
            return l;
        }
    }

    private static long read32(byte[] buffer, int offset) {
        int b0 = buffer[offset];
        int b1 = buffer[offset + 1];
        int b2 = buffer[offset + 2];
        int b3 = buffer[offset + 3];
        int i0 = (b0 & 0x80) == 128 ? (b0 & 0x7F) + 128 : b0;
        int i1 = (b1 & 0x80) == 128 ? (b1 & 0x7F) + 128 : b1;
        int i2 = (b2 & 0x80) == 128 ? (b2 & 0x7F) + 128 : b2;
        int i3 = (b3 & 0x80) == 128 ? (b3 & 0x7F) + 128 : b3;
        return ((long)i0 << 24) + ((long)i1 << 16) + ((long)i2 << 8) + (long)i3;
    }

    private static long readTimeStamp(byte[] buffer, int offset) {
        long seconds = NTPTimeMillis.read32(buffer, offset);
        long fraction = NTPTimeMillis.read32(buffer, offset + 4);
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }

    private static void writeTimeStamp(byte[] buffer, long time) {
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        int offset = 40;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)seconds;
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction >> 24);
        buffer[offset++] = (byte)(fraction >> 16);
        buffer[offset++] = (byte)(fraction >> 8);
        buffer[offset] = (byte)(Math.random() * 255.0);
    }
}

