/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.NTPTimeMillis;
import net.apexes.commons.lang.NetworkTimeMillisException;

class NetworkTimeMillis {
    private static final Logger LOG = Logger.getLogger(NetworkTimeMillis.class.getName());

    private NetworkTimeMillis() {
    }

    static long invoke(ExecutorService executor, int timeoutMs, InetSocketAddress ... addrs) throws NetworkTimeMillisException, InterruptedException, ExecutionException, TimeoutException {
        Checks.verifyNotNull(executor, "executor");
        Checks.verifyNotEmpty(addrs, "addrs");
        ArrayList resultList = new ArrayList();
        ArrayList<NetworkTimeMillisTask> taskList = new ArrayList<NetworkTimeMillisTask>();
        for (InetSocketAddress addr : addrs) {
            taskList.add(new NetworkTimeMillisTask(addr, timeoutMs));
        }
        long timeout = timeoutMs > 0 ? (long)timeoutMs * 2L + 500L : (long)timeoutMs;
        List futureList = executor.invokeAll(taskList);
        for (Future future : futureList) {
            resultList.add(future.get(timeout, TimeUnit.MILLISECONDS));
        }
        LinkedHashMap<InetSocketAddress, Long> timeMap = new LinkedHashMap<InetSocketAddress, Long>();
        LinkedHashMap<InetSocketAddress, Throwable> linkedHashMap = new LinkedHashMap<InetSocketAddress, Throwable>();
        for (Result result : resultList) {
            if (result.exception != null) {
                linkedHashMap.put(result.addr, result.exception);
                continue;
            }
            if (result.timeMillis == 0L) continue;
            timeMap.put(result.addr, result.timeMillis());
        }
        if (addrs.length == 1) {
            if (timeMap.isEmpty()) {
                throw new NetworkTimeMillisException(timeMap, linkedHashMap);
            }
            return (Long)timeMap.get(addrs[0]);
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "networkTimeMillis: {0}", timeMap);
        }
        if (timeMap.size() >= 2) {
            ArrayList timeList = new ArrayList(timeMap.values());
            Long minDiff = null;
            Long select1 = null;
            Long select2 = null;
            for (int i = timeList.size() - 1; i > 0; --i) {
                for (int j = i - 1; j >= 0; --j) {
                    long value2;
                    long value1 = (Long)timeList.get(i);
                    long diff = Math.abs(value1 - (value2 = ((Long)timeList.get(j)).longValue()));
                    if (diff == 0L) {
                        return value1;
                    }
                    if (minDiff != null && minDiff <= diff) continue;
                    minDiff = diff;
                    select1 = value1;
                    select2 = value2;
                }
            }
            if (minDiff != null && minDiff < 30000L) {
                return Math.max(select1, select2);
            }
        }
        throw new NetworkTimeMillisException(timeMap, linkedHashMap);
    }

    private static class Result {
        private final InetSocketAddress addr;
        private final Long timeMillis;
        private final long nanoTime;
        private final Exception exception;

        private Result(InetSocketAddress addr, long timeMillis) {
            this.addr = addr;
            this.timeMillis = timeMillis;
            this.nanoTime = System.nanoTime();
            this.exception = null;
        }

        private Result(InetSocketAddress addr, Exception exception) {
            this.addr = addr;
            this.timeMillis = null;
            this.nanoTime = 0L;
            this.exception = exception;
        }

        long timeMillis() {
            return this.timeMillis + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.nanoTime);
        }
    }

    private static class NetworkTimeMillisTask
    implements Callable<Result> {
        private final InetSocketAddress addr;
        private final int timeoutMs;

        private NetworkTimeMillisTask(InetSocketAddress addr, int timeoutMs) {
            this.addr = addr;
            this.timeoutMs = timeoutMs;
        }

        @Override
        public Result call() {
            try {
                long timeMillis = NTPTimeMillis.requestTime(this.addr.getAddress(), this.addr.getPort(), this.timeoutMs);
                return new Result(this.addr, timeMillis);
            }
            catch (Exception e) {
                return new Result(this.addr, e);
            }
        }
    }
}

