/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NetworkTimeMillisException
extends Exception {
    private final List<Throwable> causes = new ArrayList<Throwable>();

    NetworkTimeMillisException(Map<InetSocketAddress, Long> timeMap, Map<InetSocketAddress, Throwable> causeMap) {
        super(NetworkTimeMillisException.message(timeMap, causeMap));
        if (!causeMap.isEmpty()) {
            Throwable cause = null;
            Throwable last = null;
            for (Throwable throwable : causeMap.values()) {
                this.causes.add(throwable);
                if (cause == null) {
                    cause = throwable;
                } else if (last != null) {
                    last.initCause(throwable);
                }
                last = NetworkTimeMillisException.findLastCause(throwable);
            }
            this.initCause(cause);
        }
    }

    public boolean isCauseWith(Class<? extends Throwable> throwableClass) {
        for (Throwable cause : this.causes) {
            if (!throwableClass.isAssignableFrom(cause.getClass())) continue;
            return true;
        }
        return false;
    }

    private static String message(Map<InetSocketAddress, Long> timeMap, Map<InetSocketAddress, Throwable> causeMap) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<InetSocketAddress, Long> entry : timeMap.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(entry.getValue());
        }
        for (Map.Entry<InetSocketAddress, Serializable> entry : causeMap.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(((Throwable)entry.getValue()).getClass().getSimpleName());
        }
        return sb.toString();
    }

    private static Throwable findLastCause(Throwable throwable) {
        Throwable cause;
        Throwable last = throwable;
        while ((cause = last.getCause()) != null) {
            last = cause;
        }
        return last;
    }
}

