/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.util.ArrayList;
import java.util.List;

public class PageableHelper<T> {
    private final List<T> datas = new ArrayList<T>();
    private List<T> originals;
    private int pageSize;
    private int pageCount;
    private int currentPageIndex;

    public PageableHelper() {
        this(8);
    }

    public PageableHelper(int pageSize) {
        this(null, pageSize);
    }

    public PageableHelper(List<T> originals, int pageSize) {
        this.setOriginals(originals, pageSize);
    }

    public final void setOriginals(List<T> originals) {
        this.setOriginals(originals, this.pageSize);
    }

    public final void setOriginals(List<T> originals, int pageSize) {
        int size;
        if (pageSize <= 0) {
            throw new IllegalArgumentException("The pageSize must be greater than 0.");
        }
        this.originals = originals;
        this.pageSize = pageSize;
        this.datas.clear();
        if (originals != null && !originals.isEmpty()) {
            this.datas.addAll(originals);
        }
        this.pageCount = (size = this.datas.size()) == 0 ? 0 : (size - 1) / pageSize + 1;
        this.currentPageIndex = 0;
    }

    public final List<T> getOriginals() {
        return this.originals;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public boolean isEmpty() {
        return this.datas.isEmpty();
    }

    public boolean hasPageUp() {
        return this.currentPageIndex > 0;
    }

    public List<T> pageUp() {
        if (this.hasPageUp()) {
            --this.currentPageIndex;
            return this.get(this.currentPageIndex);
        }
        return null;
    }

    public boolean hasPageDown() {
        return this.currentPageIndex < this.pageCount - 1;
    }

    public List<T> pageDown() {
        if (this.hasPageDown()) {
            ++this.currentPageIndex;
            return this.get(this.currentPageIndex);
        }
        return null;
    }

    public List<T> get() {
        return this.get(this.currentPageIndex);
    }

    public List<T> get(int pageIndex) {
        if (this.datas.isEmpty()) {
            return null;
        }
        int bi = pageIndex * this.pageSize;
        int ei = Math.min(this.datas.size(), bi + this.pageSize);
        return this.datas.subList(bi, ei);
    }

    public boolean isFirst() {
        return this.currentPageIndex == 0;
    }

    public void toFirst() {
        this.currentPageIndex = 0;
    }

    public boolean isEnd() {
        if (this.pageCount == 0) {
            return this.currentPageIndex == 0;
        }
        return this.currentPageIndex == this.pageCount - 1;
    }

    public void toEnd() {
        this.currentPageIndex = this.pageCount == 0 ? 0 : this.pageCount - 1;
    }
}

