/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

public class Platforms {
    public static boolean isLinux() {
        return "linux".equals(Platforms.getOS());
    }

    public static boolean isWindows() {
        return "win32".equals(Platforms.getOS());
    }

    public static boolean isMacos() {
        return "darwin".equals(Platforms.getOS());
    }

    public static String getPlatform() {
        return Platforms.getOS() + "-" + Platforms.getArch();
    }

    public static String getOS() {
        String os = System.getProperty("os.name").toLowerCase().replace(" ", "");
        if (os.contains("windows")) {
            return "win32";
        }
        if ("macosx".equals(os) || "macos".equals(os)) {
            return "darwin";
        }
        return os;
    }

    public static String getArch() {
        String arch = System.getProperty("os.arch").toLowerCase().replace(" ", "");
        if ("i386".equals(arch)) {
            return "x86";
        }
        if ("amd64".equals(arch) || "x86_64".equals(arch)) {
            return "x86-64";
        }
        if ("arm64".equals(arch)) {
            return "aarch64";
        }
        if ("armhf".equals(arch) || "aarch32".equals(arch) || "armv7l".equals(arch)) {
            return "arm";
        }
        return arch;
    }
}

