/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.Closeable;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;

public final class Resources {
    private Resources() {
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            Resources.close(closeable);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Object ... objects) {
        for (Object object : objects) {
            Resources.close(object);
        }
    }

    public static void close(Object object) {
        if (object != null) {
            if (object instanceof Closeable) {
                Resources.close((Closeable)object);
            } else {
                try {
                    Method method = object.getClass().getMethod("close", new Class[0]);
                    method.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static File getJarFile(Class<?> classType) {
        File file = Resources.getProjectFile(classType);
        if (file != null && file.getName().endsWith(".jar") && file.isFile()) {
            return file;
        }
        return null;
    }

    public static String getProjectPath(Class<?> classType) {
        File file = Resources.getProjectFile(classType);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static File getProjectFile(Class<?> classType) {
        File file = null;
        if (classType.getClassLoader() == null) {
            String className = classType.getSimpleName() + ".class";
            String filePath = classType.getResource(className).getPath();
            try {
                filePath = URLDecoder.decode(filePath, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (filePath.startsWith("file:/")) {
                filePath = filePath.substring(6, filePath.indexOf(".jar!") + 4);
                file = new File(filePath);
            }
        } else {
            String filePath = classType.getProtectionDomain().getCodeSource().getLocation().getPath();
            try {
                filePath = URLDecoder.decode(filePath, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            file = new File(filePath);
        }
        return file;
    }
}

