/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.apexes.commons.lang.Base58;
import net.apexes.commons.lang.Bytes;
import net.apexes.commons.lang.Skip32;

public final class Secrets {
    private Secrets() {
    }

    public static byte[] md5(InputStream is) throws IOException, NoSuchAlgorithmException {
        int len;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] buf = new byte[8192];
        while ((len = is.read(buf)) != -1) {
            digest.update(buf, 0, len);
        }
        return digest.digest();
    }

    public static byte[] md5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] md5(String text) {
        return Secrets.md5(text, StandardCharsets.UTF_8);
    }

    public static byte[] md5(String text, String charsetName) {
        try {
            return Secrets.md5(text.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] md5(String text, Charset charset) {
        return Secrets.md5(text.getBytes(charset));
    }

    public static String md5Base58String(byte[] bytes) {
        return Base58.encode(Secrets.md5(bytes));
    }

    public static String md5Base58String(String text) {
        return Base58.encode(Secrets.md5(text));
    }

    public static String md5Base58String(String text, String charsetName) {
        return Base58.encode(Secrets.md5(text, charsetName));
    }

    public static String md5Base58String(String text, Charset charset) {
        return Base58.encode(Secrets.md5(text, charset));
    }

    public static String md5HexString(byte[] bytes) {
        return Bytes.toHex(Secrets.md5(bytes));
    }

    public static String md5HexString(String text) {
        return Bytes.toHex(Secrets.md5(text));
    }

    public static String md5HexString(String text, String charsetName) {
        return Bytes.toHex(Secrets.md5(text, charsetName));
    }

    public static String md5HexString(String text, Charset charset) {
        return Bytes.toHex(Secrets.md5(text, charset));
    }

    public static byte[] sha1(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(bytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha1(String text) {
        return Secrets.sha1(text, StandardCharsets.UTF_8);
    }

    public static byte[] sha1(String text, String charsetName) {
        try {
            return Secrets.sha1(text.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha1(String text, Charset charset) {
        return Secrets.sha1(text.getBytes(charset));
    }

    public static String sha1HexString(byte[] bytes) {
        return Bytes.toHex(Secrets.sha1(bytes));
    }

    public static String sha1HexString(String text) {
        return Bytes.toHex(Secrets.sha1(text));
    }

    public static String sha1HexString(String text, String charsetName) {
        return Bytes.toHex(Secrets.sha1(text, charsetName));
    }

    public static String sha1HexString(String text, Charset charset) {
        return Bytes.toHex(Secrets.sha1(text, charset));
    }

    public static String sha1Base58String(byte[] bytes) {
        return Base58.encode(Secrets.sha1(bytes));
    }

    public static String sha1Base58String(String text) {
        return Base58.encode(Secrets.sha1(text));
    }

    public static String sha1Base58String(String text, String charsetName) {
        return Base58.encode(Secrets.sha1(text, charsetName));
    }

    public static String sha1Base58String(String text, Charset charset) {
        return Base58.encode(Secrets.sha1(text, charset));
    }

    public static byte[] aesEncrypt(byte[] content, String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] key = new byte[16];
        int len = Math.min(bytes.length, key.length);
        System.arraycopy(key, 0, bytes, 0, len);
        return Secrets.aesEncrypt(content, key);
    }

    public static byte[] aesEncrypt(byte[] content, byte[] key) {
        return Secrets.aesEncrypt(content, key, key);
    }

    public static byte[] aesEncrypt(byte[] content, byte[] key, byte[] iv) {
        if (key.length != 16) {
            throw new IllegalArgumentException("The key is invalid.");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("The iv is invalid.");
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)keySpec, new IvParameterSpec(iv));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] aesDecrypt(byte[] content, String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] key = new byte[16];
        int len = Math.min(bytes.length, key.length);
        System.arraycopy(key, 0, bytes, 0, len);
        return Secrets.aesDecrypt(content, key);
    }

    public static byte[] aesDecrypt(byte[] content, byte[] key) {
        return Secrets.aesDecrypt(content, key, key);
    }

    public static byte[] aesDecrypt(byte[] content, byte[] key, byte[] iv) {
        if (key.length != 16) {
            throw new IllegalArgumentException("The key is invalid.");
        }
        if (iv.length != 16) {
            throw new IllegalArgumentException("The iv is invalid.");
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] desEncrypt(byte[] content, String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] key = new byte[8];
        int len = Math.min(bytes.length, key.length);
        System.arraycopy(key, 0, bytes, 0, len);
        return Secrets.desEncrypt(content, key, key);
    }

    public static byte[] desEncrypt(byte[] content, byte[] key) {
        return Secrets.desEncrypt(content, key, key);
    }

    public static byte[] desEncrypt(byte[] content, byte[] key, byte[] iv) {
        if (key.length != 8) {
            throw new IllegalArgumentException("The key is invalid.");
        }
        if (iv.length != 8) {
            throw new IllegalArgumentException("The iv is invalid.");
        }
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(new DESKeySpec(key));
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] desDecrypt(byte[] content, String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] key = new byte[8];
        int len = Math.min(bytes.length, key.length);
        System.arraycopy(key, 0, bytes, 0, len);
        return Secrets.desDecrypt(content, key, key);
    }

    public static byte[] desDecrypt(byte[] content, byte[] key) {
        return Secrets.desDecrypt(content, key, key);
    }

    public static byte[] desDecrypt(byte[] content, byte[] key, byte[] iv) {
        if (key.length != 8) {
            throw new IllegalArgumentException("The key is invalid.");
        }
        if (iv.length != 8) {
            throw new IllegalArgumentException("The iv is invalid.");
        }
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(new DESKeySpec(key));
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long skip32Encrypt(int value, String key) {
        return Skip32.encrypt(value, key);
    }

    public static int skip32Decrypt(long value, String key) {
        return Skip32.decrypt(value, key);
    }
}

