/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Streams {
    static final int BUFFER_SIZE = 8192;

    private Streams() {
    }

    public static void transfer(InputStream is, OutputStream os) throws IOException {
        Streams.transfer(is, os, null);
    }

    public static void transfer(InputStream is, OutputStream os, TransferCallback callback) throws IOException {
        byte[] buf = new byte[8192];
        if (callback == null) {
            int len;
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
            }
        } else {
            int len;
            while ((len = is.read(buf)) > 0) {
                os.write(buf, 0, len);
                callback.completed(buf, 0, len);
            }
        }
    }

    public static void transfer(File sourceFile, OutputStream targetOs, boolean snapshoot) throws Exception {
        byte[] buf = new byte[8192];
        long fileLen = sourceFile.length();
        long outLen = 0L;
        try (FileInputStream fis = new FileInputStream(sourceFile);){
            int len;
            while ((len = fis.read(buf)) != -1) {
                targetOs.write(buf, 0, len);
                if (!snapshoot || (outLen += (long)len) < fileLen) continue;
                break;
            }
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[8192];
        while ((len = is.read(buff)) > 0) {
            swapStream.write(buff, 0, len);
        }
        return swapStream.toByteArray();
    }

    public static String toString(InputStream is, String charsetName) throws IOException {
        return new String(Streams.toByteArray(is), charsetName);
    }

    public static Md5OutputStream md5OutputStream(OutputStream os) throws NoSuchAlgorithmException {
        return new Md5OutputStream(os);
    }

    public static class Md5OutputStream
    extends OutputStream {
        private final OutputStream os;
        private final MessageDigest digest;

        private Md5OutputStream(OutputStream os) throws NoSuchAlgorithmException {
            this.os = os;
            this.digest = MessageDigest.getInstance("MD5");
        }

        public byte[] md5() {
            return this.digest.digest();
        }

        @Override
        public void write(int b) throws IOException {
            this.digest.update((byte)b);
            this.os.write(b);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.digest.update(bytes);
            this.os.write(bytes);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.digest.update(bytes, off, len);
            this.os.write(bytes, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void close() throws IOException {
            this.os.close();
        }
    }

    public static interface TransferCallback {
        public void completed(byte[] var1, int var2, int var3);
    }
}

