/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Random;
import java.util.StringTokenizer;
import net.apexes.commons.lang.Bytes;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.MurmurHash;
import net.apexes.commons.lang.Radix62;
import net.apexes.commons.lang.Secrets;

public final class Strings {
    private static final Random random = new Random();
    private static final char[] UNALIKE_CHARACTER_SET = "23456789ABDEFGHJLMNQRTYabdefghijmnqrty".toCharArray();

    private Strings() {
    }

    public static String[] shorts(String src) {
        String hex = Bytes.toHex(Secrets.md5(src));
        String[] arr = new String[4];
        for (int i = 0; i < 4; ++i) {
            String sub = hex.substring(i * 8, i * 8 + 8);
            long hexLong = 0x3FFFFFFFL & Long.parseLong(sub, 16);
            StringBuilder outChars = new StringBuilder();
            for (int j = 0; j < 6; ++j) {
                long index = 0x3DL & hexLong;
                outChars.append(Radix62.ALPHABET[(int)index]);
                hexLong >>= 5;
            }
            arr[i] = outChars.toString();
        }
        return arr;
    }

    public static String hash(String src) {
        StringBuilder sb = new StringBuilder();
        for (int hash = Math.abs(MurmurHash.hash32(src)); hash > 0; hash /= Radix62.ALPHABET.length) {
            int index = hash % Radix62.ALPHABET.length;
            sb.insert(0, Radix62.ALPHABET[index]);
        }
        return sb.toString();
    }

    public static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(Radix62.ALPHABET[random.nextInt(Radix62.ALPHABET.length)]);
        }
        return sb.toString();
    }

    public static String randomLetter(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(Radix62.ALPHABET[10 + random.nextInt(Radix62.ALPHABET.length - 10)]);
        }
        return sb.toString();
    }

    public static String randomNumber(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(random.nextInt(10));
        }
        return sb.toString();
    }

    public static String randomUnalikeString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(UNALIKE_CHARACTER_SET[random.nextInt(UNALIKE_CHARACTER_SET.length)]);
        }
        return sb.toString();
    }

    public static String ltrim(String str) {
        int st;
        int len = str.length();
        char[] val = str.toCharArray();
        for (st = 0; st < len && val[st] <= ' '; ++st) {
        }
        return st > 0 ? str.substring(st, len) : str;
    }

    public static String rtrim(String str) {
        int len;
        char[] val = str.toCharArray();
        for (len = str.length(); 0 < len && val[len - 1] <= ' '; --len) {
        }
        return len < str.length() ? str.substring(0, len) : str;
    }

    public static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toTitleCase(str.charAt(0)) + str.substring(1);
    }

    public static String uncapitalized(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    @Deprecated
    public static String uncapitalize(String str) {
        return Strings.uncapitalized(str);
    }

    public static String underscore(String str) {
        if (str == null || str.trim().isEmpty()) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                sb.append("_");
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String camelCase(String str) {
        if (str == null || str.trim().isEmpty()) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '_') {
                if (++i >= len) {
                    sb.append(ch);
                    break;
                }
                sb.append(Character.toUpperCase(str.charAt(i)));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String format(String fmt, Object ... params) {
        if (params != null && params.length > 0) {
            String pattern = fmt.replaceAll("'", "''");
            return MessageFormat.format(pattern, params);
        }
        return fmt;
    }

    public static String omitString(String str, int length) {
        if (str == null) {
            return null;
        }
        if (length <= 0) {
            return "";
        }
        if (str.length() <= length) {
            return str;
        }
        StringBuilder buf1 = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        int i1 = 0;
        int i2 = str.length() - 1;
        length -= 3;
        while (length > 0) {
            char c = str.charAt(i1);
            buf1.append(c);
            ++i1;
            if (--length <= 0) continue;
            c = str.charAt(i2);
            --length;
            buf2.insert(0, c);
            --i2;
        }
        buf1.append("...");
        buf1.append((CharSequence)buf2);
        return buf1.toString();
    }

    public String truncation(String text, int maxLength) {
        if (text != null && text.length() > maxLength) {
            return text.substring(0, maxLength);
        }
        return text;
    }

    public static String join(Collection<?> collection, String separator) {
        if (collection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objects = collection.toArray();
        for (int i = 0; i < collection.size() - 1; ++i) {
            stringBuilder.append(objects[i].toString()).append(separator);
        }
        if (!collection.isEmpty()) {
            stringBuilder.append(objects[collection.size() - 1]);
        }
        return stringBuilder.toString();
    }

    public static String stringToHTMLString(String text) {
        StringBuilder sb = new StringBuilder(text.length());
        boolean lastWasBlankChar = false;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastWasBlankChar = true;
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\n') {
                sb.append("&lt;br/&gt;");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(ci);
            sb.append(';');
        }
        return sb.toString();
    }

    public static String autoincrementFilename(String filename) {
        String s2;
        String s1;
        String suffix;
        String tmp;
        int m = filename.lastIndexOf(46);
        if (m >= 0) {
            tmp = filename.substring(0, m);
            suffix = filename.substring(m);
        } else {
            tmp = filename;
            suffix = "";
        }
        int n = tmp.lastIndexOf(95);
        if (n >= 0) {
            s1 = tmp.substring(0, n);
            s2 = tmp.substring(n + 1);
        } else {
            s1 = tmp;
            s2 = "";
        }
        int i = 1;
        if (s2.matches("^[1-9]\\d*$")) {
            try {
                i = Integer.parseInt(s2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return s1 + "_" + ++i + suffix;
        }
        if (m != -1) {
            return tmp + "_" + i + suffix;
        }
        return filename + "_" + i;
    }

    public static int versionCompare(String version1, String version2) {
        block7: {
            int n2;
            int n1;
            int d;
            if (Checks.isBlank(version1)) {
                return Checks.isBlank(version2) ? 0 : -1;
            }
            if (Checks.isBlank(version2)) {
                return 1;
            }
            StringTokenizer t1 = new StringTokenizer(version1, "._");
            StringTokenizer t2 = new StringTokenizer(version2, "._");
            do {
                n1 = 0;
                n2 = 0;
                int c = 2;
                if (t1.hasMoreTokens()) {
                    n1 = Integer.parseInt(t1.nextToken());
                } else {
                    --c;
                }
                if (t2.hasMoreTokens()) {
                    n2 = Integer.parseInt(t2.nextToken());
                } else {
                    --c;
                }
                if (c == 0) break block7;
            } while ((d = Integer.compare(n1, n2)) == 0);
            return d;
        }
        return 0;
    }
}

