/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.net;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.net.StringHttpClient;

public class JsonHttpClient<R> {
    protected final StringHttpClient client;
    private final JsonEncoder jsonEncoder;
    private final JsonDecoder<R> jsonDecoder;

    public JsonHttpClient(String url, JsonEncoder encoder, JsonDecoder<R> decoder) {
        Checks.verifyNotNull(encoder, "encoder");
        Checks.verifyNotNull(decoder, "decoder");
        this.client = new StringHttpClient(url);
        this.jsonEncoder = encoder;
        this.jsonDecoder = decoder;
    }

    private JsonHttpClient(String url, JsonEncoder encoder) {
        Checks.verifyNotNull(encoder, "encoder");
        this.client = new StringHttpClient(url);
        this.jsonEncoder = encoder;
        this.jsonDecoder = null;
    }

    public JsonHttpClient<R> setAcceptCompress(boolean value) {
        this.client.setAcceptCompress(value);
        return this;
    }

    public JsonHttpClient<R> setConnectTimeout(int timeout) {
        this.client.setConnectTimeout(timeout);
        return this;
    }

    public JsonHttpClient<R> setReadTimeout(int timeout) {
        this.client.setReadTimeout(timeout);
        return this;
    }

    public JsonHttpClient<R> exemptSSL() throws KeyManagementException, NoSuchAlgorithmException {
        this.client.exemptSSL();
        return this;
    }

    public JsonHttpClient<R> setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.client.setSSLSocketFactory(sslSocketFactory);
        return this;
    }

    public JsonHttpClient<R> setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.client.setHostnameVerifier(hostnameVerifier);
        return this;
    }

    public JsonHttpClient<R> setHttpProperty(String key, String value) {
        this.client.setHttpProperty(key, value);
        return this;
    }

    public JsonHttpClient<R> setSentLogger(StringHttpClient.RequestLogger sentLogger) {
        this.client.setSentLogger(sentLogger);
        return this;
    }

    public JsonHttpClient<R> setRequestLogger(StringHttpClient.RequestLogger requestLogger) {
        this.client.setRequestLogger(requestLogger);
        return this;
    }

    public JsonHttpClient<R> setResponseLogger(StringHttpClient.ResponseLogger responseLogger) {
        this.client.setResponseLogger(responseLogger);
        return this;
    }

    public JsonHttpClient<R> setRequestEncoder(StringHttpClient.RequestEncoder requestEncoder) {
        this.client.setRequestEncoder(requestEncoder);
        return this;
    }

    public JsonHttpClient<R> setResponseReader(StringHttpClient.ResponseReader responseReader) {
        this.client.setResponseReader(responseReader);
        return this;
    }

    public R call(Object request) throws Exception {
        return this.call(request, false);
    }

    public R call(Object request, boolean compress) throws Exception {
        String requestJson = this.encode(request);
        String responseJson = this.client.doPost(requestJson, compress);
        return this.decode(responseJson);
    }

    public R callGet() throws Exception {
        String responseJson = this.client.doGet();
        return this.decode(responseJson);
    }

    protected String encode(Object request) throws Exception {
        return this.jsonEncoder.toJson(request);
    }

    protected R decode(String responseJson) throws Exception {
        if (this.jsonDecoder == null) {
            return null;
        }
        return this.jsonDecoder.fromJson(responseJson);
    }

    public static JsonHttpNoticer forNotice(String url, JsonEncoder jsonEncoder) {
        return new JsonHttpNoticer(url, jsonEncoder);
    }

    public static <R> JsonHttpClient<R> forRequest(String url, JsonEncoder jsonEncoder, JsonDecoder<R> jsonDecoder) {
        return new JsonHttpClient<R>(url, jsonEncoder, jsonDecoder);
    }

    public static interface JsonDecoder<R> {
        public R fromJson(String var1) throws Exception;
    }

    public static interface JsonEncoder {
        public String toJson(Object var1) throws Exception;
    }

    public static class JsonHttpNoticer
    extends JsonHttpClient<Void> {
        protected JsonHttpNoticer(String url, JsonEncoder jsonEncoder) {
            super(url, jsonEncoder);
        }

        public void notice(Object request) throws Exception {
            this.notice(request, false);
        }

        public void notice(Object request, boolean compress) throws Exception {
            String requestJson = this.encode(request);
            this.client.doPost(requestJson, compress);
        }
    }
}

