/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.net;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Networks;
import net.apexes.commons.net.StringHttpClient;

public class NameValuePairPoster {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final StringHttpClient client;

    public NameValuePairPoster(String url) {
        this.client = new StringHttpClient(url, CONTENT_TYPE);
    }

    public NameValuePairPoster setConnectTimeout(int timeout) {
        this.client.setConnectTimeout(timeout);
        return this;
    }

    public NameValuePairPoster setReadTimeout(int timeout) {
        this.client.setReadTimeout(timeout);
        return this;
    }

    public NameValuePairPoster exemptSSL() throws KeyManagementException, NoSuchAlgorithmException {
        this.client.exemptSSL();
        return this;
    }

    public NameValuePairPoster setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.client.setSSLSocketFactory(sslSocketFactory);
        return this;
    }

    public NameValuePairPoster setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.client.setHostnameVerifier(hostnameVerifier);
        return this;
    }

    public NameValuePairPoster setHttpProperty(String key, String value) {
        this.client.setHttpProperty(key, value);
        return this;
    }

    public NameValuePairPoster setRequestLogger(StringHttpClient.RequestLogger requestLogger) {
        this.client.setRequestLogger(requestLogger);
        return this;
    }

    public NameValuePairPoster setResponseLogger(StringHttpClient.ResponseLogger responseLogger) {
        this.client.setResponseLogger(responseLogger);
        return this;
    }

    public NameValuePairPoster setRequestEncoder(StringHttpClient.RequestEncoder requestEncoder) {
        this.client.setRequestEncoder(requestEncoder);
        return this;
    }

    public NameValuePairPoster setResponseReader(StringHttpClient.ResponseReader responseReader) {
        this.client.setResponseReader(responseReader);
        return this;
    }

    public String post(Map<String, String> request) throws Exception {
        return this.post(request, null);
    }

    public String post(Map<String, String> request, String charset) throws Exception {
        Checks.verifyNotNull(request, "request");
        if (charset != null) {
            this.client.setCharset(charset);
        }
        String body = Networks.forNameValuePair(request.entrySet(), this.client.getCharset());
        return this.client.doPost(body);
    }

    public static NameValuePairPoster forRequest(String url) {
        return new NameValuePairPoster(url);
    }
}

