/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.xml;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.apexes.commons.xml.XmlParseException;

public class XmlElement {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Map<String, String> attributes;
    private List<XmlElement> children;
    private String name;
    private XmlElement parent;
    private String content;
    private Map<String, char[]> entities;
    private int lineNr;
    private boolean ignoreWhitespace;
    private char charReadTooMuch;
    private Reader reader;
    private int parserLineNr;

    public XmlElement() {
        this(new HashMap<String, char[]>());
    }

    public XmlElement(Map<String, char[]> entities) {
        this(entities, true, true);
    }

    public XmlElement(boolean skipLeadingWhitespace) {
        this(new HashMap<String, char[]>(), skipLeadingWhitespace, true);
    }

    public XmlElement(Map<String, char[]> entities, boolean skipLeadingWhitespace) {
        this(entities, skipLeadingWhitespace, true);
    }

    protected XmlElement(Map<String, char[]> entities, boolean skipLeadingWhitespace, boolean fillBasicConversionTable) {
        this.ignoreWhitespace = skipLeadingWhitespace;
        this.name = null;
        this.parent = null;
        this.content = "";
        this.attributes = new LinkedHashMap<String, String>();
        this.children = new ArrayList<XmlElement>();
        this.entities = new HashMap<String, char[]>();
        this.lineNr = 0;
        if (entities != null && !entities.isEmpty()) {
            this.entities.putAll(entities);
        }
        if (fillBasicConversionTable) {
            this.entities.put("amp", new char[]{'&'});
            this.entities.put("quot", new char[]{'\"'});
            this.entities.put("apos", new char[]{'\''});
            this.entities.put("lt", new char[]{'<'});
            this.entities.put("gt", new char[]{'>'});
        }
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public void addChild(XmlElement child) {
        if (child == this) {
            throw new IllegalArgumentException("Child element can't is this.");
        }
        XmlElement el = this.parent;
        while (el != null) {
            if (child == el) {
                throw new IllegalArgumentException("Child element can't is super.");
            }
            el = el.parent;
        }
        child.setParent(this);
        this.children.add(child);
    }

    public void removeChild(XmlElement child) {
        child.setParent(null);
        this.children.remove(child);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XmlElement getParent() {
        return this.parent;
    }

    protected void setParent(XmlElement parent) {
        this.parent = parent;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public XmlElement getChild(int index) {
        return this.children.get(index);
    }

    public XmlElement getChild(String name) {
        for (XmlElement elt : this.children) {
            if (!name.equals(elt.getName())) continue;
            return elt;
        }
        return null;
    }

    public String getChildContent(String name) {
        XmlElement child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getContent();
    }

    public List<XmlElement> getChildren() {
        return this.children;
    }

    public List<XmlElement> getChildren(String name) {
        ArrayList<XmlElement> list = new ArrayList<XmlElement>();
        for (XmlElement elt : this.children) {
            if (!name.equals(elt.getName())) continue;
            list.add(elt);
        }
        return list;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value.toString());
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public Object getAttribute(String name, Object defaultValue) {
        Object value = this.attributes.get(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public int getIntAttribute(String name) {
        return this.getIntAttribute(name, 0);
    }

    public int getIntAttribute(String name, int defaultValue) {
        String value = this.attributes.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw this.invalidValue(name, value);
        }
    }

    public void setIntAttribute(String name, int value) {
        this.attributes.put(name, Integer.toString(value));
    }

    public long getLongAttribute(String name) {
        return this.getLongAttribute(name, 0L);
    }

    public long getLongAttribute(String name, long defaultValue) {
        String value = this.attributes.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw this.invalidValue(name, value);
        }
    }

    public void setLongAttribute(String name, long value) {
        this.attributes.put(name, Long.toString(value));
    }

    public String getStringAttribute(String name) {
        return this.getStringAttribute(name, null);
    }

    public String getStringAttribute(String name, String defaultValue) {
        return (String)this.getAttribute(name, defaultValue);
    }

    public double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, 0.0);
    }

    public double getDoubleAttribute(String name, double defaultValue) {
        String value = this.attributes.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw this.invalidValue(name, value);
        }
    }

    public void setDoubleAttribute(String name, double value) {
        this.attributes.put(name, Double.toString(value));
    }

    public boolean getBooleanAttribute(String name, String trueValue, String falseValue, boolean defaultValue) {
        String value = this.attributes.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals(trueValue)) {
            return true;
        }
        if (value.equals(falseValue)) {
            return false;
        }
        throw this.invalidValue(name, value);
    }

    public void parseFromReader(Reader reader) throws IOException, XmlParseException {
        this.parseFromReader(reader, 1);
    }

    public void parseFromReader(Reader reader, int startingLineNr) throws IOException, XmlParseException {
        char ch;
        this.name = null;
        this.content = "";
        this.attributes = new LinkedHashMap<String, String>();
        this.children = new ArrayList<XmlElement>();
        this.charReadTooMuch = '\u0000';
        this.reader = reader;
        this.parserLineNr = startingLineNr;
        while (true) {
            if ((ch = this.scanWhitespace()) != '<') {
                throw this.expectedInput("<");
            }
            ch = this.readChar();
            if (ch != '!' && ch != '?') break;
            this.skipSpecialTag(0);
        }
        this.unreadChar(ch);
        this.scanElement(this);
    }

    public void parseString(String string) throws XmlParseException {
        try {
            this.parseFromReader(new StringReader(string), 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parseString(String string, int offset) throws XmlParseException {
        this.parseString(string.substring(offset));
    }

    public void parseString(String string, int offset, int end) throws XmlParseException {
        this.parseString(string.substring(offset, end));
    }

    public void parseString(String string, int offset, int end, int startingLineNr) throws XmlParseException {
        try {
            this.parseFromReader(new StringReader(string.substring(offset, end)), startingLineNr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parseCharArray(char[] input, int offset, int end) throws XmlParseException {
        this.parseCharArray(input, offset, end, 1);
    }

    public void parseCharArray(char[] input, int offset, int end, int startingLineNr) throws XmlParseException {
        try {
            CharArrayReader reader0 = new CharArrayReader(input, offset, end);
            this.parseFromReader(reader0, startingLineNr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(Writer writer) throws IOException {
        XmlElement.write(writer, this, false, 0, 0);
    }

    public void write(Writer writer, boolean standalone, int indent) throws IOException {
        XmlElement.write(writer, this, standalone, indent, 0);
    }

    public void write(Writer writer, int indent) throws IOException {
        XmlElement.write(writer, this, true, indent, 0);
    }

    protected static void write(Writer writer, XmlElement element, boolean standalone, int indent, int level) throws IOException {
        if (element.getName() == null) {
            XmlElement.writeEncoded(writer, element.getContent());
            return;
        }
        if (level != 0) {
            if (standalone) {
                writer.append(LINE_SEPARATOR);
            }
            for (int i = indent * level; i > 0; --i) {
                writer.append(' ');
            }
        }
        writer.write(60);
        writer.write(element.getName());
        Set<String> attrNames = element.getAttributeNames();
        if (!attrNames.isEmpty()) {
            Iterator<Object> it = attrNames.iterator();
            while (it.hasNext()) {
                writer.write(32);
                String key = it.next();
                String value = element.getStringAttribute(key);
                writer.write(key);
                writer.write(61);
                writer.write(34);
                XmlElement.writeEncoded(writer, value);
                writer.write(34);
            }
        }
        if (element.getContent() != null && !element.getContent().isEmpty()) {
            writer.write(62);
            XmlElement.writeEncoded(writer, element.getContent());
            writer.write(60);
            writer.write(47);
            writer.write(element.getName());
            writer.write(62);
        } else if (element.getChildrenCount() == 0) {
            writer.write(47);
            writer.write(62);
        } else {
            writer.write(62);
            for (XmlElement child : element.getChildren()) {
                XmlElement.write(writer, child, standalone, indent, level + 1);
            }
            if (standalone || indent != 0) {
                writer.append(LINE_SEPARATOR);
            }
            if (level != 0) {
                for (int i = indent * level; i > 0; --i) {
                    writer.append(' ');
                }
            }
            writer.write(60);
            writer.write(47);
            writer.write(element.getName());
            writer.write(62);
        }
    }

    protected static void writeEncoded(Writer writer, String str) throws IOException {
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    writer.write(38);
                    writer.write(108);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '>': {
                    writer.write(38);
                    writer.write(103);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '&': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(109);
                    writer.write(112);
                    writer.write(59);
                    continue block7;
                }
                case '\"': {
                    writer.write(38);
                    writer.write(113);
                    writer.write(117);
                    writer.write(111);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '\'': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(112);
                    writer.write(111);
                    writer.write(115);
                    writer.write(59);
                    continue block7;
                }
                default: {
                    writer.write(ch);
                }
            }
        }
    }

    public String toCompactString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "utf-8");
            this.write(writer, false, 0);
            writer.flush();
            return new String(out.toByteArray(), "utf-8");
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "utf-8");
            this.write(writer, 4);
            writer.flush();
            return new String(out.toByteArray(), "utf-8");
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    protected XmlElement createAnotherElement() {
        return new XmlElement(this.entities, this.ignoreWhitespace, true);
    }

    protected void scanIdentifier(StringBuilder result) throws IOException {
        while (true) {
            char ch;
            if (!((ch = this.readChar()) >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == ':' || ch == '-' || ch > '~')) {
                this.unreadChar(ch);
                return;
            }
            result.append(ch);
        }
    }

    protected char scanWhitespace() throws IOException {
        char ch;
        block3: while (true) {
            ch = this.readChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return ch;
    }

    protected char scanWhitespace(StringBuilder buf) throws IOException {
        char ch;
        block4: while (true) {
            ch = this.readChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case ' ': {
                    buf.append(ch);
                    continue block4;
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return ch;
    }

    protected void scanString(StringBuilder buf) throws IOException {
        char delimiter = this.readChar();
        if (delimiter != '\'' && delimiter != '\"') {
            throw this.expectedInput("' or \"");
        }
        char ch;
        while ((ch = this.readChar()) != delimiter) {
            if (ch == '&') {
                this.resolveEntity(buf);
                continue;
            }
            buf.append(ch);
        }
        return;
    }

    protected boolean scanPCData(StringBuilder buf) throws IOException {
        while (true) {
            char ch;
            if ((ch = this.readChar()) == '<') {
                ch = this.readChar();
                if (ch == '!') {
                    return this.checkCDATA(buf);
                }
                this.unreadChar(ch);
                return false;
            }
            if (ch == '&') {
                this.resolveEntity(buf);
                continue;
            }
            buf.append(ch);
        }
    }

    protected boolean checkCDATA(StringBuilder buf) throws IOException {
        char ch = this.readChar();
        if (ch != '[') {
            this.unreadChar(ch);
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int delimiterCharsSkipped = 0;
        block4: while (delimiterCharsSkipped < 3) {
            int i;
            ch = this.readChar();
            switch (ch) {
                case ']': {
                    if (delimiterCharsSkipped < 2) {
                        ++delimiterCharsSkipped;
                        continue block4;
                    }
                    buf.append(']');
                    buf.append(']');
                    delimiterCharsSkipped = 0;
                    continue block4;
                }
                case '>': {
                    if (delimiterCharsSkipped < 2) {
                        for (i = 0; i < delimiterCharsSkipped; ++i) {
                            buf.append(']');
                        }
                        delimiterCharsSkipped = 0;
                        buf.append('>');
                        continue block4;
                    }
                    delimiterCharsSkipped = 3;
                    continue block4;
                }
            }
            for (i = 0; i < delimiterCharsSkipped; ++i) {
                buf.append(']');
            }
            buf.append(ch);
            delimiterCharsSkipped = 0;
        }
        return true;
    }

    protected void skipComment() throws IOException {
        int dashesToRead = 2;
        while (dashesToRead > 0) {
            char ch = this.readChar();
            if (ch == '-') {
                --dashesToRead;
                continue;
            }
            dashesToRead = 2;
        }
        if (this.readChar() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void skipSpecialTag(int bracketLevel) throws IOException {
        char ch;
        int tagLevel = 1;
        char stringDelimiter = '\u0000';
        if (bracketLevel == 0) {
            ch = this.readChar();
            if (ch == '[') {
                ++bracketLevel;
            } else if (ch == '-') {
                ch = this.readChar();
                if (ch == '[') {
                    ++bracketLevel;
                } else if (ch == ']') {
                    --bracketLevel;
                } else if (ch == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (tagLevel > 0) {
            ch = this.readChar();
            if (stringDelimiter == '\u0000') {
                if (ch == '\"' || ch == '\'') {
                    stringDelimiter = ch;
                } else if (bracketLevel <= 0) {
                    if (ch == '<') {
                        ++tagLevel;
                    } else if (ch == '>') {
                        --tagLevel;
                    }
                }
                if (ch == '[') {
                    ++bracketLevel;
                    continue;
                }
                if (ch != ']') continue;
                --bracketLevel;
                continue;
            }
            if (ch != stringDelimiter) continue;
            stringDelimiter = '\u0000';
        }
    }

    protected boolean checkLiteral(String literal) throws IOException {
        int length = literal.length();
        for (int i = 0; i < length; ++i) {
            if (this.readChar() == literal.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected char readChar() throws IOException {
        if (this.charReadTooMuch != '\u0000') {
            char ch = this.charReadTooMuch;
            this.charReadTooMuch = '\u0000';
            return ch;
        }
        int i = this.reader.read();
        if (i < 0) {
            throw this.unexpectedEndOfData();
        }
        if (i == 10) {
            ++this.parserLineNr;
            return '\n';
        }
        return (char)i;
    }

    protected void scanElement(XmlElement elt) throws IOException {
        boolean hasPCData;
        int ch;
        String eltName;
        StringBuilder buf;
        block25: {
            buf = new StringBuilder();
            this.scanIdentifier(buf);
            eltName = buf.toString();
            elt.setName(eltName);
            ch = this.scanWhitespace();
            while (ch != 62 && ch != 47) {
                buf.setLength(0);
                this.unreadChar((char)ch);
                this.scanIdentifier(buf);
                String key = buf.toString();
                ch = this.scanWhitespace();
                if (ch != 61) {
                    throw this.expectedInput("=");
                }
                this.unreadChar(this.scanWhitespace());
                buf.setLength(0);
                this.scanString(buf);
                elt.setAttribute(key, buf);
                ch = this.scanWhitespace();
            }
            if (ch == 47) {
                ch = this.readChar();
                if (ch != 62) {
                    throw this.expectedInput(">");
                }
                return;
            }
            hasPCData = false;
            buf.setLength(0);
            ch = this.scanWhitespace(buf);
            if (ch != 60) {
                this.unreadChar((char)ch);
                hasPCData = this.scanPCData(buf);
            } else {
                while ((ch = this.readChar()) == 33) {
                    if (this.checkCDATA(buf)) {
                        this.scanPCData(buf);
                        hasPCData = true;
                    } else {
                        ch = this.scanWhitespace(buf);
                        if (ch == 60) continue;
                        this.unreadChar((char)ch);
                        hasPCData = this.scanPCData(buf);
                    }
                    break block25;
                }
                if (ch != 47 || this.ignoreWhitespace) {
                    buf.setLength(0);
                }
                if (ch == 47) {
                    this.unreadChar((char)ch);
                }
            }
        }
        if (buf.length() == 0) {
            while (ch != 47) {
                if (ch == 33) {
                    if (hasPCData) {
                        ch = 47;
                        break;
                    }
                    ch = this.readChar();
                    if (ch != 45) {
                        throw this.expectedInput("Comment or Element");
                    }
                    ch = this.readChar();
                    if (ch != 45) {
                        throw this.expectedInput("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    this.unreadChar((char)ch);
                    XmlElement child = this.createAnotherElement();
                    this.scanElement(child);
                    elt.addChild(child);
                }
                ch = this.scanWhitespace();
                if (ch != 60) {
                    throw this.expectedInput("<");
                }
                ch = this.readChar();
            }
            this.unreadChar((char)ch);
        } else if (this.ignoreWhitespace) {
            elt.setContent(buf.toString().trim());
        } else {
            elt.setContent(buf.toString());
        }
        ch = this.readChar();
        if (ch != 47) {
            throw this.expectedInput("/");
        }
        this.unreadChar(this.scanWhitespace());
        if (!this.checkLiteral(eltName)) {
            throw this.expectedInput(eltName);
        }
        if (this.scanWhitespace() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void resolveEntity(StringBuilder buf) throws IOException {
        char ch = '\u0000';
        StringBuilder keyBuf = new StringBuilder();
        while ((ch = this.readChar()) != ';') {
            keyBuf.append(ch);
        }
        String key = keyBuf.toString();
        if (key.charAt(0) == '#') {
            try {
                ch = key.charAt(1) == 'x' ? (char)Integer.parseInt(key.substring(2), 16) : (char)Integer.parseInt(key.substring(1), 10);
            }
            catch (NumberFormatException e) {
                throw this.unknownEntity(key);
            }
            buf.append(ch);
        } else {
            char[] value = this.entities.get(key);
            if (value == null) {
                throw this.unknownEntity(key);
            }
            buf.append(value);
        }
    }

    protected void unreadChar(char ch) {
        this.charReadTooMuch = ch;
    }

    protected XmlParseException invalidValueSet(String name) {
        String msg = "Invalid value set (entity name = \"" + name + "\")";
        return new XmlParseException(this.getName(), this.parserLineNr, msg);
    }

    protected XmlParseException invalidValue(String name, String value) {
        String msg = "Attribute \"" + name + "\" does not contain a valid value (\"" + value + "\")";
        return new XmlParseException(this.getName(), this.parserLineNr, msg);
    }

    protected XmlParseException unexpectedEndOfData() {
        String msg = "Unexpected end of data reached";
        return new XmlParseException(this.getName(), this.parserLineNr, msg);
    }

    protected XmlParseException syntaxError(String context) {
        String msg = "Syntax error while parsing " + context;
        return new XmlParseException(this.getName(), this.parserLineNr, msg);
    }

    protected XmlParseException expectedInput(String charSet) {
        String msg = "Expected: " + charSet;
        return new XmlParseException(this.getName(), this.parserLineNr, msg);
    }

    protected XmlParseException unknownEntity(String name) {
        String msg = "Unknown or invalid entity: &" + name + ";";
        return new XmlParseException(this.getName(), this.parserLineNr, msg);
    }
}

