/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.apexes.commons.xml.XmlElement;

public final class Xmls {
    private Xmls() {
    }

    public static XmlElement node(XmlElement xml, String path) {
        String[] nodes;
        String start;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.startsWith(start = "/" + xml.getName() + "/")) {
            return null;
        }
        path = path.replaceFirst(start, "");
        for (String node : nodes = path.split("/")) {
            if ((xml = xml.getChild(node)) != null) continue;
            return null;
        }
        return xml;
    }

    public static String nodeContent(XmlElement xml, String path) {
        if ((xml = Xmls.node(xml, path)) == null) {
            return null;
        }
        return xml.getContent();
    }

    public static String nodeAttr(XmlElement xml, String path, String name) {
        if ((xml = Xmls.node(xml, path)) == null) {
            return null;
        }
        return xml.getStringAttribute(name);
    }

    public static String nodeAttr(XmlElement xml, String path, String name, String defaultValue) {
        if ((xml = Xmls.node(xml, path)) == null) {
            return null;
        }
        return xml.getStringAttribute(name, defaultValue);
    }

    public static XmlElement xml(String xml) {
        XmlElement xe = new XmlElement();
        xe.parseString(xml);
        return xe;
    }

    public static XmlElement xml(File xmlFile, Charset charset) throws IOException {
        return Xmls.xml(xmlFile, charset.name());
    }

    public static XmlElement xml(File xmlFile, String charsetName) throws IOException {
        try (InputStream in = Files.newInputStream(xmlFile.toPath(), new OpenOption[0]);){
            XmlElement xmlElement = Xmls.xml(in, charsetName);
            return xmlElement;
        }
    }

    public static XmlElement xml(InputStream input, Charset charset) throws IOException {
        return Xmls.xml(input, charset.name());
    }

    public static XmlElement xml(InputStream input, String charsetName) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(input, charsetName);){
            XmlElement xmlElement = Xmls.xml(reader);
            return xmlElement;
        }
    }

    public static XmlElement xml(Reader reader) throws IOException {
        XmlElement xml = new XmlElement(true);
        xml.parseFromReader(reader);
        return xml;
    }

    public static void save(XmlElement xml, File xmlFile, Charset charset) throws IOException {
        Xmls.save(xml, xmlFile, charset.name());
    }

    public static void save(XmlElement xml, File xmlFile, String charsetName) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(xmlFile.toPath(), new OpenOption[0]), charsetName);){
            xml.write(writer, true, 4);
            ((Writer)writer).flush();
        }
    }
}

