/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.querydsl.info;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 */
public class ForeignKeyInfo {
    
    private final String name;

    private final String foreignSchema;
    
    private final String parentSchema;
    
    private final String foreignTable;

    private final String parentTable;

    private final List<String> foreignColumns = new ArrayList<String>();

    private final List<String> parentColumns = new ArrayList<String>();
    
    ForeignKeyInfo(String name, String foreignSchema, String foreignTable) {
        this(name, foreignSchema, foreignSchema, foreignTable, foreignTable);
    }

    ForeignKeyInfo(String name, String foreignSchema, String parentSchema,
            String foreignTable, String parentTable) {
        this.name = name;
        this.foreignSchema = foreignSchema;
        this.parentSchema = parentSchema;
        this.foreignTable = foreignTable;
        this.parentTable = parentTable;
    }

    public void add(String foreignColumn, String parentColumn) {
        foreignColumns.add(foreignColumn);
        parentColumns.add(parentColumn);
    }

    public String getName() {
        return name;
    }
    
    public String getForeignSchema() {
        return foreignSchema;
    }

    public String getParentSchema() {
        return parentSchema;
    }

    public String getForeignTable() {
        return foreignTable;
    }

    public String getParentTable() {
        return parentTable;
    }

    public List<String> getForeignColumns() {
        return foreignColumns;
    }

    public List<String> getParentColumns() {
        return parentColumns;
    }

}
