/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.querydsl.types.dsl;

import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.dsl.SimplePath;
import net.apexes.commons.lang.Enume;

import javax.annotation.Nullable;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 * @param <T>
 */
public class EnumePath<T extends Enume<?>> extends SimplePath<T> {
    
    private static final long serialVersionUID = 1L;
    
    @Nullable
    private transient volatile OrderSpecifier<T> asc, desc;

    public EnumePath(Class<? extends T> type, PathMetadata metadata) {
        super(type, metadata);
    }
    
    /**
     * Create an OrderSpecifier for ascending order of this expression
     *
     * @return ascending order by this
     */
    public final OrderSpecifier<T> asc() {
        if (asc == null) {
            asc = new OrderSpecifier<T>(Order.ASC, mixin);
        }
        return asc;
    }
    
    /**
     * Create an OrderSpecifier for descending order of this expression
     *
     * @return descending order by this
     */
    public final OrderSpecifier<T> desc() {
        if (desc == null) {
            desc = new OrderSpecifier<T>(Order.DESC, mixin);
        }
        return desc;
    }

}
