/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl;

import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.apexes.commons.lang.Checks;

public class ExcludeColumns {
    private Path<?>[] excludeColumns;

    public static ExcludeColumns of(Path<?> ... excludeColumns) {
        return new ExcludeColumns(excludeColumns);
    }

    public ExcludeColumns(Path<?> ... excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public ExcludeColumns add(ExcludeColumns exclude) {
        Checks.verifyNotNull((Object)exclude, (String)"exclude");
        if (exclude.excludeColumns != null) {
            return this.add(exclude.excludeColumns);
        }
        return this;
    }

    public ExcludeColumns add(Path<?> ... excludeColumns) {
        Checks.verifyNotEmpty((Object[])excludeColumns, (String)"excludeColumns");
        ArrayList list = new ArrayList(this.excludeColumns.length + excludeColumns.length);
        for (Path<?> column : this.excludeColumns) {
            list.add(column);
        }
        for (Path<?> column : excludeColumns) {
            if (list.contains(column)) continue;
            list.add(column);
        }
        this.excludeColumns = list.toArray(new Path[list.size()]);
        return this;
    }

    public ExcludeColumns remove(Path<?> ... excludeColumns) {
        if (excludeColumns == null) {
            throw new IllegalArgumentException("(excludeColumns == null)");
        }
        if (excludeColumns.length == 0) {
            throw new IllegalArgumentException("(excludeColumns.length == 0)");
        }
        ArrayList list = new ArrayList(this.excludeColumns.length);
        for (Path<?> column : this.excludeColumns) {
            list.add(column);
        }
        for (Path<?> column : excludeColumns) {
            if (!list.contains(column)) continue;
            list.remove(column);
        }
        this.excludeColumns = list.toArray(new Path[list.size()]);
        return this;
    }

    public Path<?>[] getExcludeColumns() {
        if (this.excludeColumns == null) {
            ArrayList list = new ArrayList();
            this.excludeColumns = list.toArray(new Path[0]);
        }
        return this.excludeColumns;
    }

    public boolean hasColumns() {
        return this.excludeColumns != null && this.excludeColumns.length != 0;
    }

    public Map<Path<?>, Path<?>> getExcludeColumnsBag() {
        HashMap excludeColumnsBag = new HashMap();
        for (Path<?> col : this.excludeColumns) {
            excludeColumnsBag.put(col, col);
        }
        return excludeColumnsBag;
    }
}

