/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl;

import com.querydsl.core.types.Path;
import com.querydsl.sql.RelationalPath;
import java.util.ArrayList;
import net.apexes.commons.lang.Checks;

public class IncludeColumns {
    private Path<?>[] includeColumns;

    public static IncludeColumns of(RelationalPath<?> path) {
        return new IncludeColumns(path);
    }

    public static IncludeColumns of(Path<?> ... includeColumns) {
        return new IncludeColumns(includeColumns);
    }

    public IncludeColumns(RelationalPath<?> path) {
        this.includeColumns = path.getColumns().toArray(new Path[0]);
    }

    public IncludeColumns(Path<?> ... includeColumns) {
        this.includeColumns = includeColumns;
    }

    public IncludeColumns add(IncludeColumns include) {
        Checks.verifyNotNull((Object)include, (String)"include");
        if (include.includeColumns != null) {
            return this.add(include.includeColumns);
        }
        return this;
    }

    public IncludeColumns add(Path<?> ... includeColumns) {
        Checks.verifyNotEmpty((Object[])includeColumns, (String)"includeColumns");
        ArrayList list = new ArrayList(this.includeColumns.length + includeColumns.length);
        for (Path<?> column : this.includeColumns) {
            list.add(column);
        }
        for (Path<?> column : includeColumns) {
            if (list.contains(column)) continue;
            list.add(column);
        }
        this.includeColumns = list.toArray(new Path[list.size()]);
        return this;
    }

    public Path<?>[] getIncludeColumns() {
        if (this.includeColumns == null) {
            ArrayList list = new ArrayList(0);
            this.includeColumns = list.toArray(new Path[0]);
        }
        return this.includeColumns;
    }

    public boolean hasColumns() {
        return this.includeColumns != null && this.includeColumns.length != 0;
    }
}

