/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.sql.SQLQuery;
import java.util.List;

public final class Mappings {
    public <T> MappingBuilder<T> of(Class<T> classType, Expression<?> ... expressions) {
        return new MappingBuilder((Class)classType, (Expression[])expressions);
    }

    public static MappingSQLBuilder of(SQLQuery<?> sqlQuery, Expression<?> ... expressions) {
        return new MappingSQLBuilder(sqlQuery).columns(expressions);
    }

    public static MappingSQLBuilder of(SQLQuery<?> sqlQuery) {
        return new MappingSQLBuilder(sqlQuery);
    }

    public static interface VoidMapping {
        public void map(Tuple var1);
    }

    public static interface Mapping<T> {
        public T map(Tuple var1);
    }

    private static class MappingAdapter
    implements Mapping<Void> {
        private final VoidMapping mapping;

        public MappingAdapter(VoidMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public Void map(Tuple row) {
            this.mapping.map(row);
            return null;
        }
    }

    private static class ProjectionAdapter<T>
    extends MappingProjection<T> {
        private static final long serialVersionUID = 1L;
        private final Mapping<T> mapping;

        public ProjectionAdapter(Mapping<T> mapping, Class<T> classType, Expression<?> ... expressions) {
            super(classType, expressions);
            this.mapping = mapping;
        }

        protected T map(Tuple row) {
            return this.mapping.map(row);
        }
    }

    public static class MappingSQLBuilder {
        private final SQLQuery<?> sqlQuery;
        private Expression<?>[] expressions;

        private MappingSQLBuilder(SQLQuery<?> sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        public MappingSQLBuilder columns(Expression<?> ... expressions) {
            this.expressions = expressions;
            return this;
        }

        public void fetch(VoidMapping mapping) {
            this.sqlQuery.select(new ProjectionAdapter<Void>(new MappingAdapter(mapping), Void.class, this.expressions)).fetch();
        }

        public <T> List<T> fetch(Class<T> classType, Mapping<T> mapping) {
            return this.sqlQuery.select(this.mapping(classType, mapping)).fetch();
        }

        public <T> T fetchFirst(Class<T> classType, Mapping<T> mapping) {
            return (T)this.sqlQuery.select(this.mapping(classType, mapping)).fetchFirst();
        }

        public <T> T fetchOne(Class<T> classType, Mapping<T> mapping) {
            return (T)this.sqlQuery.select(this.mapping(classType, mapping)).fetchOne();
        }

        private <T> MappingProjection<T> mapping(Class<T> classType, Mapping<T> mapping) {
            return new ProjectionAdapter<T>(mapping, classType, this.expressions);
        }
    }

    public static class MappingBuilder<T> {
        private final Class<T> classType;
        private final Expression<?>[] expressions;

        private MappingBuilder(Class<T> classType, Expression<?> ... expressions) {
            this.classType = classType;
            this.expressions = expressions;
        }

        public MappingProjection<T> mapping(Mapping<T> mapping) {
            return new ProjectionAdapter<T>(mapping, this.classType, this.expressions);
        }
    }
}

