/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.querydsl.EntityProjection;
import net.apexes.commons.querydsl.ExcludeColumns;
import net.apexes.commons.querydsl.IncludeColumns;
import net.apexes.commons.querydsl.PathValuePair;
import net.apexes.commons.querydsl.sql.TablePathBase;

public class QuerydslHelper<T, ID extends Serializable> {
    private final TablePathBase<T> qvar;
    private final Class<T> entityClass;
    private final Map<String, PathInfo> pathInfoFinder;
    private final Path<?>[] allPathArr;
    private final Path<ID> pkPath;
    private final Path<?>[] withoutPkPathArr;
    private final boolean hasBlobClobPath;

    public QuerydslHelper(TablePathBase<T> qvar) {
        PropertyDescriptor[] descriptors;
        this.qvar = qvar;
        this.entityClass = qvar.getType();
        HashMap<String, PropertyDescriptor> propMap = new HashMap<String, PropertyDescriptor>();
        HashMap<String, Path> pathMap = new HashMap<String, Path>();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Path path : qvar.getColumns()) {
            String name = this.pathName(path);
            pathMap.put(name, path);
            Field field = QuerydslHelper.findField(this.entityClass, name);
            if (field == null) {
                throw new RuntimeException(this.entityClass.getName() + "." + name + " not found!");
            }
            fieldMap.put(name, field);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.entityClass);
            descriptors = beanInfo.getPropertyDescriptors();
            if (descriptors == null) {
                descriptors = new PropertyDescriptor[]{};
            }
        }
        catch (IntrospectionException e) {
            descriptors = new PropertyDescriptor[]{};
        }
        for (PropertyDescriptor desc : descriptors) {
            String propName = desc.getName();
            if ("class".equalsIgnoreCase(propName)) continue;
            propMap.put(propName, desc);
        }
        if (pathMap.isEmpty()) {
            throw new RuntimeException(this.entityClass.getName() + " paths is empty");
        }
        boolean blobClobPath = false;
        this.pathInfoFinder = new LinkedHashMap<String, PathInfo>();
        for (Map.Entry entry : pathMap.entrySet()) {
            PropertyDescriptor desc;
            Field field;
            String name = (String)entry.getKey();
            Path path = (Path)entry.getValue();
            PathInfo pathInfo = new PathInfo(path, field = (Field)fieldMap.get(name), desc = (PropertyDescriptor)propMap.get(name));
            if (pathInfo.blobClobPath) {
                blobClobPath = true;
            }
            this.pathInfoFinder.put(name, pathInfo);
        }
        this.hasBlobClobPath = blobClobPath;
        int qvarColumnCount = qvar.getColumns().size();
        if (qvarColumnCount != this.pathInfoFinder.size()) {
            throw new RuntimeException(this.entityClass.getName() + " column count is wrong. " + qvarColumnCount + " <> " + this.pathInfoFinder.size());
        }
        List pkPaths = qvar.getPrimaryKey().getLocalColumns();
        if (pkPaths.size() != 1) {
            throw new RuntimeException(this.entityClass.getName() + " primary key must be the only.");
        }
        this.pkPath = (Path)pkPaths.get(0);
        PathInfo pkPathInfo = this.pathInfoFinder.get(this.pkPath.getMetadata().getName());
        if (pkPathInfo == null) {
            throw new RuntimeException(this.entityClass.getName() + " primary key count is wrong.");
        }
        ArrayList<Path> allPaths = new ArrayList<Path>();
        ArrayList<Path> withoutPkPaths = new ArrayList<Path>();
        for (PathInfo info : this.pathInfoFinder.values()) {
            allPaths.add(info.path);
            if (pkPathInfo.name.equals(info.name)) continue;
            withoutPkPaths.add(info.path);
        }
        this.withoutPkPathArr = withoutPkPaths.toArray(new Path[0]);
        this.allPathArr = allPaths.toArray(new Path[0]);
    }

    public TablePathBase<T> getQvar() {
        return this.qvar;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public Path<ID> pkPath() {
        return this.pkPath;
    }

    public Path<?>[] allPaths() {
        return this.allPathArr;
    }

    public Path<?>[] withoutPkColumns() {
        return this.withoutPkPathArr;
    }

    public boolean hasBlobClobPath() {
        return this.hasBlobClobPath;
    }

    public boolean isEntityColumn(OrderSpecifier<?> order) {
        return this.qvar.getColumns().contains(order.getTarget());
    }

    public boolean isEntityColumn(Path<?> path) {
        return this.qvar.getColumns().contains(path);
    }

    public boolean isPkColumn(Path<?> path) {
        return this.pkPath.equals(path);
    }

    public Path<?> getPath(String pathName) {
        Checks.verifyNotNull((Object)pathName, (String)"pathName");
        PathInfo pathInfo = this.pathInfoFinder.get(pathName);
        if (pathInfo != null) {
            return pathInfo.path;
        }
        return null;
    }

    public <E> E getValue(T entity, Path<E> path) {
        PathInfo pathInfo = this.pathInfoFinder.get(this.pathName(path));
        if (pathInfo == null) {
            throw new RuntimeException(entity.getClass().getName() + " not found path " + path);
        }
        try {
            return (E)pathInfo.desc.getReadMethod().invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(T entity, Path<?> path, Object value) {
        PathInfo pathInfo = this.pathInfoFinder.get(this.pathName(path));
        if (pathInfo == null) {
            throw new RuntimeException(entity.getClass().getName() + " not found path " + path);
        }
        try {
            pathInfo.desc.getWriteMethod().invoke(entity, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object[] entityValues(T entity) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (PathInfo pathInfo : this.pathInfoFinder.values()) {
            try {
                list.add(pathInfo.desc.getReadMethod().invoke(entity, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return list.toArray();
    }

    public String pathName(Path<?> path) {
        return path.getMetadata().getName();
    }

    public String columnName(Path<?> path) {
        return this.qvar.getMetadata(path).getName();
    }

    public String tableName() {
        return this.qvar.getTableName();
    }

    public BooleanExpression pkValueEqExpr(ID pk) {
        Checks.verifyNotNull(pk, (String)"pk");
        return ((SimpleExpression)this.pkPath).eq(pk);
    }

    public EntityProjection<T, ID> createtProjection(IncludeColumns includeColumns) {
        return new EntityProjection(this, this.qvar, includeColumns.getIncludeColumns());
    }

    public EntityProjection<T, ID> createtProjection(ExcludeColumns excludeColumns) {
        Map<Path<?>, Path<?>> excludeColumnsBag = excludeColumns.getExcludeColumnsBag();
        ArrayList includeColumns = new ArrayList();
        for (Path<?> col : this.allPathArr) {
            if (excludeColumnsBag.containsKey(col)) continue;
            includeColumns.add(col);
        }
        Path[] cols = includeColumns.toArray(new Path[includeColumns.size()]);
        return new EntityProjection(this, this.qvar, cols);
    }

    public PathValuePair<T, ID> createPathValuePair(T entity, Path<?>[] paths) {
        return new PathValuePair(this, entity, paths);
    }

    public PathValuePair<T, ID> createPathValuePair(T entity, IncludeColumns includeColumns) {
        return this.createPathValuePair(entity, includeColumns.getIncludeColumns());
    }

    public PathValuePair<T, ID> createPathValuePair(T entity, ExcludeColumns excludeColumns) {
        Map<Path<?>, Path<?>> excludeColumnsBag = excludeColumns.getExcludeColumnsBag();
        ArrayList includeColumns = new ArrayList();
        for (Path<?> col : this.allPathArr) {
            if (excludeColumnsBag.containsKey(col)) continue;
            includeColumns.add(col);
        }
        Path[] columns = includeColumns.toArray(new Path[includeColumns.size()]);
        return this.createPathValuePair(entity, columns);
    }

    private static Field findField(Class<?> clazz, String fieldName) {
        Field field = null;
        while (clazz != Object.class) {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return field;
    }

    protected static class PathInfo {
        private final String name;
        private final Path<?> path;
        private final Field field;
        private final PropertyDescriptor desc;
        private final boolean blobClobPath;

        public PathInfo(Path<?> path, Field field, PropertyDescriptor desc) {
            if (path == null) {
                throw new RuntimeException("path is null");
            }
            if (field == null) {
                throw new RuntimeException("field is null");
            }
            if (desc == null) {
                throw new RuntimeException("desc is null");
            }
            this.name = path.getMetadata().getName();
            this.path = path;
            this.field = field;
            this.desc = desc;
            Class<?> pahtType = desc.getPropertyType();
            this.blobClobPath = pahtType == byte[].class || pahtType == char[].class || Blob.class.isAssignableFrom(pahtType) || Clob.class.isAssignableFrom(pahtType);
        }

        public String toString() {
            return "PathInfo [path=" + this.path + ", field=" + this.field + ", desc=" + this.desc + "]";
        }
    }
}

