/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl.info;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.apexes.commons.querydsl.info.ColumnInfo;
import net.apexes.commons.querydsl.info.ForeignKeyInfo;
import net.apexes.commons.querydsl.info.IndexColumn;
import net.apexes.commons.querydsl.info.IndexInfo;
import net.apexes.commons.querydsl.info.PrimaryKeyInfo;

public class TableInfo {
    private static final int FK_FOREIGN_COLUMN_NAME = 8;
    private static final int FK_FOREIGN_TABLE_NAME = 7;
    private static final int FK_FOREIGN_SCHEMA_NAME = 6;
    private static final int FK_NAME = 12;
    private static final int FK_PARENT_COLUMN_NAME = 4;
    private static final int FK_PARENT_TABLE_NAME = 3;
    private static final int FK_PARENT_SCHEMA_NAME = 2;
    private static final int PK_COLUMN_NAME = 4;
    private static final int PK_NAME = 6;
    private final String catalog;
    private final String schema;
    private final String tableName;
    private final boolean lowerCase;
    private final PrimaryKeyInfo primaryKey;
    private final List<ColumnInfo> columns;
    private final List<ForeignKeyInfo> importedKeys;
    private final List<ForeignKeyInfo> exportedKeys;
    private final List<IndexInfo> indexs;

    public TableInfo(DatabaseMetaData md, String catalog, String schema, String tableName) throws SQLException {
        this(md, catalog, schema, tableName, false);
    }

    public TableInfo(DatabaseMetaData md, String catalog, String schema, String tableName, boolean lowerCase) throws SQLException {
        this.catalog = catalog;
        this.schema = schema;
        this.tableName = tableName;
        this.lowerCase = lowerCase;
        this.primaryKey = this.buildPrimaryKey(md);
        this.columns = this.buildColumn(md);
        this.importedKeys = this.buildImportedKeys(md);
        this.exportedKeys = this.buildExportedKeys(md);
        this.indexs = new ArrayList<IndexInfo>();
        this.buildUniqueKeysAndIndexs(md);
    }

    private PrimaryKeyInfo buildPrimaryKey(DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getPrimaryKeys(this.catalog, this.schema, this.tableName);){
            PrimaryKeyInfo pkInfo = null;
            while (rs.next()) {
                String columnName = TableInfo.normalizeSQLName(rs.getString(4));
                if (pkInfo == null) {
                    String name = rs.getString(6);
                    if (name == null || name.isEmpty()) {
                        name = this.tableName + "_PK";
                    }
                    pkInfo = new PrimaryKeyInfo(name, this.schema, this.tableName);
                }
                pkInfo.add(columnName);
            }
            PrimaryKeyInfo primaryKeyInfo = pkInfo;
            return primaryKeyInfo;
        }
    }

    private List<ColumnInfo> buildColumn(DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getColumns(this.catalog, this.schema, this.tableName.replace("/", "//"), null);){
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            while (rs.next()) {
                String columnName = this.normalize(rs.getString("COLUMN_NAME"));
                String normalizedColumnName = TableInfo.normalizeSQLName(columnName);
                int columnType = rs.getInt("DATA_TYPE");
                String typeName = rs.getString("TYPE_NAME");
                Integer columnSize = (Integer)rs.getObject("COLUMN_SIZE");
                Integer columnDigits = (Integer)rs.getObject("DECIMAL_DIGITS");
                int columnIndex = rs.getInt("ORDINAL_POSITION");
                int nullable = rs.getInt("NULLABLE");
                String defaultValue = rs.getString("COLUMN_DEF");
                String describe = rs.getString("REMARKS");
                list.add(new ColumnInfo(columnName, normalizedColumnName, columnType, typeName, columnSize, columnDigits, columnIndex, nullable, defaultValue, describe));
            }
            ArrayList<ColumnInfo> arrayList = list;
            return arrayList;
        }
    }

    private List<ForeignKeyInfo> buildImportedKeys(DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getImportedKeys(this.catalog, this.schema, this.tableName);){
            TreeMap<String, ForeignKeyInfo> map = new TreeMap<String, ForeignKeyInfo>();
            while (rs.next()) {
                ForeignKeyInfo fkInfo;
                String name = rs.getString(12);
                String parentSchemaName = TableInfo.normalizeSQLName(rs.getString(2));
                String parentTableName = TableInfo.normalizeSQLName(rs.getString(3));
                String parentColumnName = TableInfo.normalizeSQLName(rs.getString(4));
                String foreignSchemaName = TableInfo.normalizeSQLName(rs.getString(6));
                String foreignTableName = TableInfo.normalizeSQLName(rs.getString(7));
                String foreignColumn = TableInfo.normalizeSQLName(rs.getString(8));
                if (name == null || name.isEmpty()) {
                    name = this.tableName + "_" + parentTableName + "_FK";
                }
                if ((fkInfo = (ForeignKeyInfo)map.get(name)) == null) {
                    fkInfo = new ForeignKeyInfo(name, foreignSchemaName, parentSchemaName, foreignTableName, parentTableName);
                    map.put(name, fkInfo);
                }
                fkInfo.add(foreignColumn, parentColumnName);
            }
            ArrayList<ForeignKeyInfo> arrayList = new ArrayList<ForeignKeyInfo>(map.values());
            return arrayList;
        }
    }

    private List<ForeignKeyInfo> buildExportedKeys(DatabaseMetaData md) throws SQLException {
        try (ResultSet rs = md.getExportedKeys(this.catalog, this.schema, this.tableName);){
            TreeMap<String, ForeignKeyInfo> map = new TreeMap<String, ForeignKeyInfo>();
            while (rs.next()) {
                ForeignKeyInfo fkInfo;
                String name = rs.getString(12);
                String parentSchemaName = TableInfo.normalizeSQLName(rs.getString(2));
                String parentTableName = TableInfo.normalizeSQLName(rs.getString(3));
                String parentColumnName = TableInfo.normalizeSQLName(rs.getString(4));
                String foreignSchemaName = TableInfo.normalizeSQLName(rs.getString(6));
                String foreignTableName = TableInfo.normalizeSQLName(rs.getString(7));
                String foreignColumn = TableInfo.normalizeSQLName(rs.getString(8));
                if (name == null || name.isEmpty()) {
                    name = this.tableName + "_" + foreignTableName + "_IFK";
                }
                if ((fkInfo = (ForeignKeyInfo)map.get(name)) == null) {
                    fkInfo = new ForeignKeyInfo(name, foreignSchemaName, parentSchemaName, foreignTableName, parentTableName);
                    map.put(name, fkInfo);
                }
                fkInfo.add(foreignColumn, parentColumnName);
            }
            ArrayList<ForeignKeyInfo> arrayList = new ArrayList<ForeignKeyInfo>(map.values());
            return arrayList;
        }
    }

    private void buildUniqueKeysAndIndexs(DatabaseMetaData md) throws SQLException {
        TreeMap<String, IndexInfo> indexInfos = new TreeMap<String, IndexInfo>();
        try (ResultSet rs = md.getIndexInfo(this.catalog, this.schema, this.tableName, false, false);){
            while (rs.next()) {
                String name = rs.getString("INDEX_NAME");
                boolean nonUnique = rs.getBoolean("NON_UNIQUE");
                String ascDesc = rs.getString("ASC_OR_DESC");
                String columnName = TableInfo.normalizeSQLName(rs.getString("COLUMN_NAME"));
                String indexSchemaName = TableInfo.normalizeSQLName(rs.getString("TABLE_SCHEM"));
                String indexTableName = TableInfo.normalizeSQLName(rs.getString("TABLE_NAME"));
                if (name == null || name.isEmpty()) continue;
                IndexInfo idxInfo = (IndexInfo)indexInfos.get(name);
                if (idxInfo == null) {
                    idxInfo = new IndexInfo(name, indexSchemaName, indexTableName, !nonUnique);
                    indexInfos.put(name, idxInfo);
                }
                boolean desc = "D".equalsIgnoreCase(ascDesc);
                idxInfo.addColumn(new IndexColumn(columnName, desc));
            }
        }
        for (IndexInfo ixInfo : indexInfos.values()) {
            ArrayList<String> ixColumns = new ArrayList<String>();
            for (IndexColumn column : ixInfo.getColumns()) {
                ixColumns.add(column.getColumnName());
            }
            if (ixColumns.equals(this.primaryKey.getColumns())) continue;
            boolean accept = true;
            for (ForeignKeyInfo fkInfo : this.importedKeys) {
                if (!ixColumns.equals(fkInfo.getForeignColumns())) continue;
                accept = false;
                break;
            }
            if (!accept) continue;
            this.indexs.add(ixInfo);
        }
    }

    private String normalize(String str) {
        if (this.lowerCase && str != null) {
            return str.toLowerCase();
        }
        return str;
    }

    public String getTableName() {
        return this.tableName;
    }

    public PrimaryKeyInfo getPrimaryKey() {
        return this.primaryKey;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public List<ForeignKeyInfo> getImportedKeys() {
        return this.importedKeys;
    }

    public List<ForeignKeyInfo> getExportedKeys() {
        return this.exportedKeys;
    }

    public List<IndexInfo> getIndexs() {
        return this.indexs;
    }

    private static String normalizeSQLName(String name) {
        if (name != null) {
            return name.replaceAll("\r", "").replaceAll("\n", " ");
        }
        return null;
    }
}

