/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl.sql;

import com.google.common.collect.Lists;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.querydsl.Index;
import net.apexes.commons.querydsl.IndexBuilder;
import net.apexes.commons.querydsl.sql.EnumePath;

public class TablePathBase<E>
extends RelationalPathBase<E> {
    private static final long serialVersionUID = 1L;
    private final List<Index> indexs = Lists.newArrayList();
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final Map<ForeignKey<?>, String> foreignKeyTables = new HashMap();

    public TablePathBase(Class<? extends E> type, String variable, String schema, String table) {
        this(type, PathMetadataFactory.forVariable((String)variable), schema, table);
    }

    public TablePathBase(Class<? extends E> type, PathMetadata metadata, String schema, String table) {
        super(type, metadata, schema, table);
    }

    protected <P extends Path<?>> P addMetadata(P path, ColumnMetadata metadata, String defaultValue) {
        this.defaultValues.put(metadata.getName(), defaultValue);
        return (P)super.addMetadata(path, metadata);
    }

    protected <F extends Enume<?>> EnumePath<F> createEnume(String property, Class<? super F> type) {
        return (EnumePath)this.add((Path)new EnumePath<F>(type, this.forProperty(property)));
    }

    protected IndexBuilder index(String name) {
        return new IndexBuilder((RelationalPath<?>)this, name, this.indexs);
    }

    public List<Index> getIndexs() {
        return Collections.unmodifiableList(this.indexs);
    }

    public String getDefaultValue(String columnName) {
        return this.defaultValues.get(columnName);
    }

    public boolean hasDefaultValue(Path<?> path) {
        String columnName = this.getMetadata(path).getName();
        return this.defaultValues.containsKey(columnName);
    }

    protected <F> ForeignKey<F> createForeignKey(Path<?> local, String foreignTable, String foreignColumn) {
        ForeignKey foreignKey = super.createForeignKey(local, foreignColumn);
        this.foreignKeyTables.put(foreignKey, foreignTable);
        return foreignKey;
    }

    protected <F> ForeignKey<F> createForeignKey(List<? extends Path<?>> local, String foreignTable, List<String> foreignColumns) {
        ForeignKey foreignKey = super.createForeignKey(local, foreignColumns);
        this.foreignKeyTables.put(foreignKey, foreignTable);
        return foreignKey;
    }

    public <F> String getForeignTable(ForeignKey<F> foreignKey) {
        return this.foreignKeyTables.get(foreignKey);
    }
}

