/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl.support;

import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.types.JSR310LocalDateTimeType;
import com.querydsl.sql.types.JSR310LocalDateType;
import com.querydsl.sql.types.JSR310LocalTimeType;
import com.querydsl.sql.types.Type;
import com.querydsl.sql.types.UtilDateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.apexes.commons.lang.Enume;
import net.apexes.commons.lang.EnumeRegistry;
import net.apexes.commons.querydsl.types.BlobByteArrayType;
import net.apexes.commons.querydsl.types.EnumeByIntegerValueType;
import net.apexes.commons.querydsl.types.EnumeByStringValueType;
import net.apexes.commons.querydsl.types.EnumeType;
import net.apexes.commons.querydsl.types.UtilDate2DateType;

public class QuerydslEnumeSupport {
    private final EnumeRegistry enumeRegistry;
    private final List<TypeWrap> wrapList;

    public QuerydslEnumeSupport(EnumeRegistry enumeRegistry) {
        this.enumeRegistry = enumeRegistry;
        this.wrapList = new ArrayList<TypeWrap>();
        for (EnumeRegistry.EnumeInfo info : enumeRegistry.getEnumeInfos()) {
            Class classType;
            Class enumeClass = info.getEnumeClass();
            Class valueClass = Enume.valueClass((Class)enumeClass);
            if (valueClass == String.class) {
                classType = enumeClass;
                this.wrapList.add(new TypeWrap(new EnumeByStringValueType(classType), info.getTableColumns()));
                continue;
            }
            if (valueClass != Integer.class) continue;
            classType = enumeClass;
            this.wrapList.add(new TypeWrap(new EnumeByIntegerValueType(classType), info.getTableColumns()));
        }
    }

    public Collection<Class<? extends Enume<?>>> getEnumeClasses() {
        return this.enumeRegistry.getEnumeClasses();
    }

    public Collection<Type<?>> getEnumeTypes() {
        ArrayList enumeTypes = new ArrayList();
        for (TypeWrap wrap : this.wrapList) {
            enumeTypes.add(wrap.enumeType);
        }
        return Collections.unmodifiableCollection(enumeTypes);
    }

    public Configuration register(Configuration configuration, List<String> tables) {
        for (TypeWrap wrap : this.wrapList) {
            for (EnumeRegistry.TableColumn tc : wrap.tableColumns) {
                for (String column : tc.getColumns()) {
                    if (tc.getTable() == null) {
                        for (String table : tables) {
                            configuration.register(table, column, wrap.enumeType);
                        }
                        continue;
                    }
                    configuration.register(tc.getTable(), column, wrap.enumeType);
                }
            }
        }
        return configuration;
    }

    public Configuration simpleConfiguration(SQLTemplates templates, List<String> tables) {
        return this.register(QuerydslEnumeSupport.simpleConfiguration(templates), tables);
    }

    public static Configuration simpleConfiguration(SQLTemplates templates) {
        Configuration configuration = new Configuration(templates);
        configuration.register((Type)new BlobByteArrayType());
        configuration.register((Type)new JSR310LocalDateTimeType());
        configuration.register((Type)new JSR310LocalDateType());
        configuration.register((Type)new JSR310LocalTimeType());
        return configuration;
    }

    public static Configuration utilDateConfiguration(SQLTemplates templates) {
        Configuration configuration = new Configuration(templates);
        configuration.register((Type)new BlobByteArrayType());
        configuration.register((Type)new UtilDate2DateType());
        configuration.register((Type)new UtilDateType());
        return configuration;
    }

    private static class TypeWrap {
        final EnumeType<?> enumeType;
        final List<EnumeRegistry.TableColumn> tableColumns;

        TypeWrap(EnumeType<?> enumeType, List<EnumeRegistry.TableColumn> tableColumns) {
            this.enumeType = enumeType;
            this.tableColumns = tableColumns;
        }
    }
}

