/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl.types;

import com.querydsl.sql.types.AbstractType;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobByteArrayType
extends AbstractType<byte[]> {
    public BlobByteArrayType() {
        super(2004);
    }

    public Class<byte[]> getReturnedClass() {
        return byte[].class;
    }

    public byte[] getValue(ResultSet rs, int startIndex) throws SQLException {
        Blob blob = rs.getBlob(startIndex);
        if (blob == null) {
            return null;
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    public void setValue(PreparedStatement st, int startIndex, byte[] value) throws SQLException {
        if (value == null) {
            st.setBlob(startIndex, (Blob)null);
        } else {
            Blob blob = st.getConnection().createBlob();
            blob.setBytes(1L, value);
            st.setBlob(startIndex, blob);
        }
    }
}

