/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl;

import com.querydsl.core.types.Path;
import com.querydsl.sql.RelationalPath;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.apexes.commons.querydsl.Index;

public class IndexBuilder {
    private final RelationalPath<?> entity;
    private final String indexName;
    private final List<Index> indexs;
    private final Map<Path<?>, Boolean> columnMap;
    private boolean unique;

    public IndexBuilder(RelationalPath<?> entity, String indexName, List<Index> indexs) {
        this.entity = entity;
        this.indexName = indexName;
        this.indexs = indexs;
        this.columnMap = new LinkedHashMap();
    }

    public IndexBuilder unique() {
        this.unique = true;
        return this;
    }

    public IndexBuilder column(Path<?> column) {
        return this.column(column, false);
    }

    public IndexBuilder column(Path<?> column, boolean desc) {
        this.columnMap.put(column, desc);
        return this;
    }

    public final Index build() {
        ArrayList<Index.IndexPath> columns = new ArrayList<Index.IndexPath>();
        for (Map.Entry<Path<?>, Boolean> entry : this.columnMap.entrySet()) {
            Path<?> path = entry.getKey();
            Boolean desc = entry.getValue();
            columns.add(new Index.IndexPath(path, desc));
        }
        Index index = new Index(this.entity, this.indexName, this.unique, columns);
        this.indexs.add(index);
        return index;
    }
}

