/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.querydsl.Dao;
import net.apexes.commons.querydsl.ExcludeColumns;
import net.apexes.commons.querydsl.GroupBy;
import net.apexes.commons.querydsl.IncludeColumns;
import net.apexes.commons.querydsl.Paging;
import net.apexes.commons.querydsl.PathValuePair;
import net.apexes.commons.querydsl.QuerydslHelper;
import net.apexes.commons.querydsl.sql.TablePathBase;

public class QuerydslDao<E, ID extends Serializable>
implements Dao<E, ID> {
    private final SQLQueryFactory factory;
    private final TablePathBase<E> qvar;
    private final QuerydslHelper<E, ID> helper;

    public QuerydslDao(SQLQueryFactory factory, TablePathBase<E> qvar) {
        Checks.verifyNotNull((Object)factory, (String)"factory");
        Checks.verifyNotNull(qvar, (String)"qvar");
        this.factory = factory;
        this.qvar = qvar;
        this.helper = new QuerydslHelper(qvar);
    }

    public SQLQueryFactory getFactory() {
        return this.factory;
    }

    protected QuerydslHelper<E, ID> getQuerydslHelper() {
        return this.helper;
    }

    @Override
    public Dao.SelectExecuter<E, ID> select() {
        return new SelectExecuterImpl();
    }

    @Override
    public Dao.SelectExecuter<E, ID> select(Path<?> ... columns) {
        if (columns.length == 0) {
            return new SelectExecuterImpl();
        }
        return new SelectExecuterImpl(IncludeColumns.of(columns));
    }

    @Override
    public Dao.SelectExecuter<E, ID> selectExclude(Path<?> ... columns) {
        return new SelectExecuterImpl(ExcludeColumns.of(columns));
    }

    @Override
    public List<E> find(BooleanExpression condition, OrderSpecifier<?> ... orders) {
        return this.find(condition, (ExcludeColumns)null, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, Paging paging, OrderSpecifier<?> ... orders) {
        return this.find(condition, (ExcludeColumns)null, paging, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, ExcludeColumns excludeColumns, OrderSpecifier<?> ... orders) {
        return this.find(condition, excludeColumns, (GroupBy)null, (Paging)null, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, ExcludeColumns excludeColumns, Paging paging, OrderSpecifier<?> ... orders) {
        return this.find(condition, excludeColumns, null, paging, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, ExcludeColumns excludeColumns, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        return this.find(condition, excludeColumns, groupBy, (Paging)null, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, ExcludeColumns excludeColumns, GroupBy groupBy, Paging paging, OrderSpecifier<?> ... orders) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        return this.fetch(condition, excludeColumns, paging, groupBy, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, IncludeColumns includeColumns, OrderSpecifier<?> ... orders) {
        return this.find(condition, includeColumns, (GroupBy)null, (Paging)null, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, IncludeColumns includeColumns, Paging paging, OrderSpecifier<?> ... orders) {
        return this.find(condition, includeColumns, null, paging, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, IncludeColumns includeColumns, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        return this.find(condition, includeColumns, groupBy, (Paging)null, orders);
    }

    @Override
    public List<E> find(BooleanExpression condition, IncludeColumns includeColumns, GroupBy groupBy, Paging paging, OrderSpecifier<?> ... orders) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        return this.fetch(condition, includeColumns, paging, groupBy, orders);
    }

    @Override
    public List<E> findAll(OrderSpecifier<?> ... orders) {
        return this.fetch((SQLQuery)((SQLQuery)this.factory.select(this.qvar).from(this.qvar)).orderBy(orders));
    }

    @Override
    public List<E> findAll(Paging paging, OrderSpecifier<?> ... orders) {
        return this.findAll((IncludeColumns)null, (Paging)null, orders);
    }

    @Override
    public List<E> findAll(IncludeColumns includeColumns, OrderSpecifier<?> ... orders) {
        return this.findAll(includeColumns, (Paging)null, orders);
    }

    @Override
    public List<E> findAll(IncludeColumns includeColumns, Paging paging, OrderSpecifier<?> ... orders) {
        return this.fetch(null, includeColumns, paging, null, orders);
    }

    @Override
    public List<E> findAll(ExcludeColumns excludeColumns, OrderSpecifier<?> ... orders) {
        return this.findAll(excludeColumns, (Paging)null, orders);
    }

    @Override
    public List<E> findAll(ExcludeColumns excludeColumns, Paging paging, OrderSpecifier<?> ... orders) {
        return this.fetch(null, excludeColumns, paging, null, orders);
    }

    @Override
    public E findByPk(ID pk) {
        Checks.verifyNotNull(pk, (String)"pk");
        return this.findOne(this.pkValueEqExpr(pk));
    }

    @Override
    public E findByPk(ID pk, IncludeColumns includeColumns) {
        Checks.verifyNotNull(pk, (String)"pk");
        return this.findOne(this.pkValueEqExpr(pk), includeColumns);
    }

    @Override
    public E findByPk(ID pk, ExcludeColumns excludeColumns) {
        Checks.verifyNotNull(pk, (String)"pk");
        return this.findOne(this.pkValueEqExpr(pk), excludeColumns);
    }

    @Override
    public E findOne(BooleanExpression condition) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        return this.fetchOne((Expression<E>)this.qvar, condition, null);
    }

    @Override
    public E findOne(BooleanExpression condition, IncludeColumns includeColumns) {
        return this.findOne(condition, includeColumns, null);
    }

    @Override
    public E findOne(BooleanExpression condition, IncludeColumns includeColumns, GroupBy groupBy) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        TablePathBase<E> projection = this.qvar;
        if (includeColumns != null) {
            projection = this.listColumns(includeColumns);
        }
        return this.fetchOne((Expression<E>)projection, condition, groupBy);
    }

    @Override
    public E findOne(BooleanExpression condition, ExcludeColumns excludeColumns) {
        return this.findOne(condition, excludeColumns, null);
    }

    @Override
    public E findOne(BooleanExpression condition, ExcludeColumns excludeColumns, GroupBy groupBy) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        TablePathBase<E> projection = this.qvar;
        if (excludeColumns != null) {
            projection = this.listColumns(excludeColumns);
        }
        return this.fetchOne((Expression<E>)projection, condition, groupBy);
    }

    @Override
    public E findFirst(BooleanExpression condition, OrderSpecifier<?> ... orders) {
        return this.findFirst(condition, (GroupBy)null, orders);
    }

    @Override
    public E findFirst(BooleanExpression condition, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        return this.fetchFirst((Expression<E>)this.qvar, condition, groupBy, orders);
    }

    @Override
    public E findFirst(BooleanExpression condition, IncludeColumns includeColumns, OrderSpecifier<?> ... orders) {
        return this.findFirst(condition, includeColumns, (GroupBy)null, orders);
    }

    @Override
    public E findFirst(BooleanExpression condition, IncludeColumns includeColumns, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        TablePathBase<E> projection = this.qvar;
        if (includeColumns != null) {
            projection = this.listColumns(includeColumns);
        }
        return this.fetchFirst((Expression<E>)projection, condition, groupBy, orders);
    }

    @Override
    public E findFirst(BooleanExpression condition, ExcludeColumns excludeColumns, OrderSpecifier<?> ... orders) {
        return this.findFirst(condition, excludeColumns, (GroupBy)null, orders);
    }

    @Override
    public E findFirst(BooleanExpression condition, ExcludeColumns excludeColumns, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        TablePathBase<E> projection = this.qvar;
        if (excludeColumns != null) {
            projection = this.listColumns(excludeColumns);
        }
        return this.fetchFirst((Expression<E>)projection, condition, groupBy, orders);
    }

    @Override
    public boolean exist() {
        return this.fetchFirst((SQLQuery)this.factory.selectOne().from(this.qvar)) != null;
    }

    @Override
    public boolean exist(BooleanExpression condition) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        return this.fetchFirst((SQLQuery)((SQLQuery)this.factory.selectOne().from(this.qvar)).where((Predicate)condition)) != null;
    }

    @Override
    public boolean notExist() {
        return !this.exist();
    }

    @Override
    public boolean notExist(BooleanExpression condition) {
        return !this.exist(condition);
    }

    @Override
    public boolean existByPk(ID pk) {
        Checks.verifyNotNull(pk, (String)"pk");
        BooleanExpression pkCondition = this.pkValueEqExpr(pk);
        return this.fetchFirst((SQLQuery)((SQLQuery)this.factory.selectOne().from(this.qvar)).where((Predicate)pkCondition)) != null;
    }

    @Override
    public boolean notExistByPk(ID pk) {
        return !this.existByPk(pk);
    }

    @Override
    public long count() {
        return this.fetchCount(this.factory.selectFrom(this.qvar));
    }

    @Override
    public long count(BooleanExpression condition) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        return this.fetchCount((SQLQuery)this.factory.selectFrom(this.qvar).where((Predicate)condition));
    }

    @Override
    public long insert(E entity) {
        Checks.verifyNotNull(entity, (String)"entity");
        return this.executeInsert(this.insertPathValuePair(entity));
    }

    @Override
    public long insertBatch(List<E> list) {
        Checks.verifyNotNull(list, (String)"list");
        ArrayList<PathValuePair<PathValuePair<E, ID>, ID>> pairList = new ArrayList<PathValuePair<PathValuePair<E, ID>, ID>>();
        for (E entity : list) {
            pairList.add(this.insertPathValuePair(entity));
        }
        return this.executeInsertBatch(pairList);
    }

    @Override
    public Dao.UpdateExecuter<E, ID> update() {
        return new UpdateExecuterImpl();
    }

    @Override
    public Dao.UpdateExecuter<E, ID> update(BooleanExpression where) {
        return new UpdateExecuterImpl().where(where);
    }

    @Override
    public Dao.UpdateExecuter<E, ID> update(ID pk) {
        return new UpdateExecuterImpl().where(pk);
    }

    @Override
    public long update(BooleanExpression condition, E entity, Path<?> ... updatePaths) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotEmpty((Object[])updatePaths, (String)"updatePaths");
        return this.updateImpl(condition, this.helper.createPathValuePair(entity, updatePaths));
    }

    @Override
    public long update(BooleanExpression condition, E entity, IncludeColumns includeColumns) {
        Checks.verifyNotNull((Object)includeColumns, (String)"includeColumns");
        return this.update(condition, entity, includeColumns.getIncludeColumns());
    }

    @Override
    public long update(BooleanExpression condition, E entity, ExcludeColumns excludeColumns) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotNull((Object)excludeColumns, (String)"excludeColumns");
        return this.updateImpl(condition, this.helper.createPathValuePair(entity, excludeColumns));
    }

    @Override
    public boolean updateByPk(ID pk, E entity) {
        return this.updateByPk(pk, entity, this.helper.withoutPkColumns());
    }

    @Override
    public boolean updateByPk(ID pk, E entity, Path<?> ... updatePaths) {
        Checks.verifyNotNull(pk, (String)"pk");
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotEmpty((Object[])updatePaths, (String)"updatePaths");
        for (Path<?> column : updatePaths) {
            if (!this.helper.isPkColumn(column)) continue;
            throw new RuntimeException("doest't support update pk column itself, column:" + column);
        }
        BooleanExpression pkCondition = this.pkValueEqExpr(pk);
        return this.updateOneImpl(pkCondition, this.helper.createPathValuePair(entity, updatePaths));
    }

    @Override
    public boolean updateByPk(ID pk, E entity, IncludeColumns includeColumns) {
        Checks.verifyNotNull((Object)includeColumns, (String)"includeColumns");
        return this.updateByPk(pk, entity, includeColumns.getIncludeColumns());
    }

    @Override
    public boolean updateByPk(ID pk, E entity, ExcludeColumns excludeColumns) {
        Checks.verifyNotNull(pk, (String)"pk");
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotNull((Object)excludeColumns, (String)"excludeColumns");
        ExcludeColumns excludeCols = new ExcludeColumns(new Path[0]);
        boolean excludePk = false;
        for (Path<?> column : excludeColumns.getExcludeColumns()) {
            excludeCols.add(column);
            if (!this.helper.isPkColumn(column)) continue;
            excludePk = true;
        }
        if (!excludePk) {
            excludeCols.add(this.helper.pkPath());
        }
        BooleanExpression pkCondition = this.pkValueEqExpr(pk);
        return this.updateOneImpl(pkCondition, this.helper.createPathValuePair(entity, excludeCols));
    }

    @Override
    public boolean updateOne(BooleanExpression condition, E entity, Path<?> ... updatePaths) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotNull(updatePaths, (String)"updatePaths");
        return this.updateOneImpl(condition, this.helper.createPathValuePair(entity, updatePaths));
    }

    @Override
    public boolean updateOne(BooleanExpression condition, E entity, IncludeColumns includeColumns) {
        Checks.verifyNotNull((Object)includeColumns, (String)"includeColumns");
        return this.updateOne(condition, entity, includeColumns.getIncludeColumns());
    }

    @Override
    public boolean updateOne(BooleanExpression condition, E entity, ExcludeColumns excludeColumns) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotNull((Object)excludeColumns, (String)"excludeColumns");
        return this.updateOneImpl(condition, this.helper.createPathValuePair(entity, excludeColumns));
    }

    @Override
    public long updateAll(E entity, Path<?> ... updatePaths) {
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotEmpty((Object[])updatePaths, (String)"updatePaths");
        return this.updateImpl(null, this.helper.createPathValuePair(entity, updatePaths));
    }

    @Override
    public long updateAll(E entity, IncludeColumns includeColumns) {
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotNull((Object)includeColumns, (String)"includeColumns");
        return this.updateImpl(null, this.helper.createPathValuePair(entity, includeColumns));
    }

    @Override
    public long updateAll(E entity, ExcludeColumns excludeColumns) {
        Checks.verifyNotNull(entity, (String)"entity");
        Checks.verifyNotNull((Object)excludeColumns, (String)"excludeColumns");
        return this.updateImpl(null, this.helper.createPathValuePair(entity, excludeColumns));
    }

    @Override
    public boolean deleteByPk(ID pk) {
        Checks.verifyNotNull(pk, (String)"pk");
        BooleanExpression pkCondition = this.pkValueEqExpr(pk);
        return this.deleteOneImpl(pkCondition);
    }

    @Override
    public boolean deleteOne(BooleanExpression condition) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        return this.deleteOneImpl(condition);
    }

    @Override
    public long delete(BooleanExpression condition) {
        Checks.verifyNotNull((Object)condition, (String)"condition");
        return this.deleteImpl(condition);
    }

    private BooleanExpression pkValueEqExpr(ID pk) {
        return this.helper.pkValueEqExpr(pk);
    }

    private SQLQuery<E> groupBy(SQLQuery<E> sqlQuery, GroupBy groupBy) {
        if (groupBy != null) {
            sqlQuery = (SQLQuery)sqlQuery.groupBy(groupBy.getColumns());
            if (groupBy.getHavings() != null && groupBy.getColumns().length > 0) {
                sqlQuery = (SQLQuery)sqlQuery.having(groupBy.getHavings());
            }
        }
        return sqlQuery;
    }

    private IncludeColumns addOrderByColumns(IncludeColumns includeColumns, OrderSpecifier<?> ... orders) {
        if (includeColumns != null && orders != null) {
            for (OrderSpecifier<?> order : orders) {
                includeColumns.add((Path)order.getTarget());
            }
        }
        return includeColumns;
    }

    private ExcludeColumns addOrderByColumns(ExcludeColumns excludeColumns, OrderSpecifier<?> ... orders) {
        if (excludeColumns != null && orders != null) {
            for (OrderSpecifier<?> order : orders) {
                excludeColumns.remove((Path)order.getTarget());
            }
        }
        return excludeColumns;
    }

    private List<E> fetch(BooleanExpression condition, ExcludeColumns excludeColumns, Paging paging, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        excludeColumns = this.addOrderByColumns(excludeColumns, orders);
        Expression<E> projection = this.listColumns(excludeColumns);
        return this.fetch(projection, condition, paging, groupBy, orders);
    }

    private List<E> fetch(BooleanExpression condition, IncludeColumns includeColumns, Paging paging, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        includeColumns = this.addOrderByColumns(includeColumns, orders);
        Expression<E> projection = this.listColumns(includeColumns);
        return this.fetch(projection, condition, paging, groupBy, orders);
    }

    private List<E> fetch(Expression<E> projection, BooleanExpression condition, Paging paging, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        SQLQuery<E> sqlQuery = this.selectQuery(projection, condition, paging, groupBy, orders);
        return this.fetch(sqlQuery);
    }

    private E fetchOne(Expression<E> projection, BooleanExpression condition, GroupBy groupBy) {
        SQLQuery<E> sqlQuery = this.selectQuery(projection, condition, null, groupBy, new OrderSpecifier[0]);
        return this.fetchOne(sqlQuery);
    }

    private E fetchFirst(Expression<E> projection, BooleanExpression condition, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        SQLQuery<E> sqlQuery = this.selectQuery(projection, condition, null, groupBy, orders);
        return this.fetchFirst(sqlQuery);
    }

    private SQLQuery<E> selectQuery(Expression<E> projection, BooleanExpression condition, Paging paging, GroupBy groupBy, OrderSpecifier<?> ... orders) {
        SQLQuery sqlQuery = (SQLQuery)this.factory.select(projection).from(this.qvar);
        if (orders != null) {
            sqlQuery = (SQLQuery)sqlQuery.orderBy(orders);
        }
        if (condition != null) {
            sqlQuery = (SQLQuery)sqlQuery.where((Predicate)condition);
        }
        if (paging != null) {
            sqlQuery = (SQLQuery)sqlQuery.offset(paging.getOffset());
            if (paging.getLimit() != null) {
                sqlQuery = (SQLQuery)sqlQuery.limit(paging.getLimit().longValue());
            }
        }
        if (groupBy != null) {
            sqlQuery = this.groupBy(sqlQuery, groupBy);
        }
        return sqlQuery;
    }

    protected <I> long fetchCount(SQLQuery<I> sqlQuery) {
        return this.filerSelectQuery(sqlQuery).fetchCount();
    }

    protected <I> I fetchOne(SQLQuery<I> sqlQuery) {
        return (I)this.filerSelectQuery(sqlQuery).fetchOne();
    }

    protected <I> I fetchFirst(SQLQuery<I> sqlQuery) {
        return (I)this.filerSelectQuery(sqlQuery).fetchFirst();
    }

    protected <I> List<I> fetch(SQLQuery<I> sqlQuery) {
        return this.filerSelectQuery(sqlQuery).fetch();
    }

    protected <I> SQLQuery<I> filerSelectQuery(SQLQuery<I> sqlQuery) {
        return sqlQuery;
    }

    private Expression<E> listColumns(IncludeColumns includeColumns) {
        if (includeColumns == null) {
            return this.qvar;
        }
        if (!includeColumns.hasColumns()) {
            return this.qvar;
        }
        return this.helper.createtProjection(includeColumns);
    }

    private Expression<E> listColumns(ExcludeColumns excludeColumns) {
        if (excludeColumns == null) {
            return this.qvar;
        }
        if (!excludeColumns.hasColumns()) {
            return this.qvar;
        }
        return this.helper.createtProjection(excludeColumns);
    }

    private PathValuePair<E, ID> insertPathValuePair(E entity) {
        Path<?>[] paths = this.helper.allPaths();
        Object[] values = this.helper.entityValues(entity);
        ArrayList pathList = new ArrayList();
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            if (values[i] == null && this.qvar.hasDefaultValue(paths[i])) continue;
            pathList.add(paths[i]);
            valueList.add(values[i]);
        }
        return this.insertPathValuePair(pathList, valueList);
    }

    protected PathValuePair<E, ID> insertPathValuePair(List<Path<?>> pathList, List<Object> valueList) {
        return new PathValuePair(pathList, valueList);
    }

    protected long executeInsert(PathValuePair<E, ID> pair) {
        return ((SQLInsertClause)((SQLInsertClause)this.factory.insert(this.qvar).columns(pair.getPaths())).values(pair.getValues())).execute();
    }

    protected long executeInsertBatch(List<PathValuePair<E, ID>> pairList) {
        SQLInsertClause clause = this.factory.insert(this.qvar);
        for (PathValuePair<E, ID> pair : pairList) {
            ((SQLInsertClause)((SQLInsertClause)clause.columns(pair.getPaths())).values(pair.getValues())).addBatch();
        }
        return clause.execute();
    }

    private boolean updateOneImpl(BooleanExpression condition, PathValuePair<E, ID> pair) {
        return this.updateOneImpl(condition, pair.getPathsAsList(), pair.getValuesAsList());
    }

    private boolean updateOneImpl(BooleanExpression condition, List<Path<?>> paths, List<?> values) {
        return this.updateImpl(condition, paths, values) == 1L;
    }

    private long updateImpl(BooleanExpression condition, PathValuePair<E, ID> pair) {
        return this.updateImpl(condition, pair.getPathsAsList(), pair.getValuesAsList());
    }

    private long updateImpl(BooleanExpression condition, List<Path<?>> paths, List<?> values) {
        for (Path<?> path : paths) {
            if (!this.helper.isEntityColumn(path)) {
                throw new RuntimeException("not found column. " + path);
            }
            if (!this.helper.isPkColumn(path)) continue;
            throw new IllegalArgumentException("update doesn't support update pk column. " + path);
        }
        return this.executeUpdate(condition, this.updatePathValuePair(paths, values));
    }

    protected PathValuePair<E, ID> updatePathValuePair(List<Path<?>> pathList, List<?> valueList) {
        return new PathValuePair(pathList, valueList);
    }

    protected long executeUpdate(BooleanExpression condition, PathValuePair<E, ID> pair) {
        return ((SQLUpdateClause)((SQLUpdateClause)this.factory.update(this.qvar).set(pair.getPathsAsList(), pair.getValuesAsList())).where((Predicate)condition)).execute();
    }

    private boolean deleteOneImpl(BooleanExpression condition) {
        return this.executeDelete(condition) == 1L;
    }

    private long deleteImpl(BooleanExpression condition) {
        return this.executeDelete(condition);
    }

    protected long executeDelete(BooleanExpression condition) {
        return ((SQLDeleteClause)this.factory.delete(this.qvar).where((Predicate)condition)).execute();
    }

    private class UpdateValueExecuterImpl
    implements Dao.UpdateValueExecuter<E, ID> {
        private final List<Path<?>> paths;
        private final List<Object> values;
        private BooleanExpression where;

        private UpdateValueExecuterImpl(BooleanExpression where) {
            this.where = where;
            this.paths = new ArrayList();
            this.values = new ArrayList<Object>();
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> set(Path<T> column, T value) {
            this.paths.add(column);
            this.values.add(value);
            return this;
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> set(Path<T> column, Expression<? extends T> expression) {
            this.paths.add(column);
            this.values.add(expression);
            return this;
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> setIf(boolean condition, Path<T> column, T value) {
            if (condition) {
                this.paths.add(column);
                this.values.add(value);
            }
            return this;
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> setIf(boolean condition, Path<T> column, Expression<? extends T> expression) {
            if (condition) {
                this.paths.add(column);
                this.values.add(expression);
            }
            return this;
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> setNull(Path<T> column) {
            this.paths.add(column);
            this.values.add(null);
            return this;
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> set(Path<T> column, T value, T defaultValue) {
            Checks.verifyNotNull(defaultValue, (String)"defaultValue");
            this.paths.add(column);
            this.values.add(value != null ? value : defaultValue);
            return this;
        }

        @Override
        public Dao.UpdateValueExecuter<E, ID> where(BooleanExpression where) {
            this.where = where;
            return this;
        }

        @Override
        public Dao.UpdateValueExecuter<E, ID> where(ID pk) {
            this.where = QuerydslDao.this.pkValueEqExpr(pk);
            return this;
        }

        @Override
        public long execute() {
            Checks.verifyNotNull((Object)this.where, (String)"where");
            return QuerydslDao.this.updateImpl(this.where, this.paths, this.values);
        }

        @Override
        public boolean executeOne() {
            Checks.verifyNotNull((Object)this.where, (String)"where");
            return QuerydslDao.this.updateOneImpl(this.where, this.paths, this.values);
        }
    }

    private class UpdateEntityExecuterImpl
    implements Dao.UpdateEntityExecuter<E, ID> {
        private final E entity;
        private IncludeColumns includeColumns;
        private ExcludeColumns excludeColumns;
        private BooleanExpression where;

        private UpdateEntityExecuterImpl(E entity, BooleanExpression where) {
            this.entity = entity;
            this.where = where;
        }

        @Override
        public Dao.UpdateEntityExecuter<E, ID> include(Path<?> ... columns) {
            this.includeColumns = IncludeColumns.of(columns);
            this.excludeColumns = null;
            return this;
        }

        @Override
        public Dao.UpdateEntityExecuter<E, ID> exclude(Path<?> ... columns) {
            this.includeColumns = null;
            this.excludeColumns = ExcludeColumns.of(columns);
            return this;
        }

        @Override
        public Dao.UpdateEntityExecuter<E, ID> where(BooleanExpression where) {
            this.where = where;
            return this;
        }

        @Override
        public Dao.UpdateEntityExecuter<E, ID> where(ID pk) {
            this.where = QuerydslDao.this.pkValueEqExpr(pk);
            return this;
        }

        @Override
        public long execute() {
            if (this.excludeColumns != null) {
                return QuerydslDao.this.update(this.where, this.entity, this.excludeColumns);
            }
            if (this.includeColumns != null) {
                return QuerydslDao.this.update(this.where, this.entity, this.includeColumns);
            }
            return QuerydslDao.this.update(this.where, this.entity, QuerydslDao.this.helper.withoutPkColumns());
        }

        @Override
        public boolean executeOne() {
            if (this.excludeColumns != null) {
                return QuerydslDao.this.updateOne(this.where, this.entity, this.excludeColumns);
            }
            if (this.includeColumns != null) {
                return QuerydslDao.this.updateOne(this.where, this.entity, this.includeColumns);
            }
            return QuerydslDao.this.updateOne(this.where, this.entity, QuerydslDao.this.helper.withoutPkColumns());
        }
    }

    private class UpdateExecuterImpl
    implements Dao.UpdateExecuter<E, ID> {
        private BooleanExpression where;

        private UpdateExecuterImpl() {
        }

        @Override
        public Dao.UpdateExecuter<E, ID> where(BooleanExpression where) {
            this.where = where;
            return this;
        }

        @Override
        public Dao.UpdateExecuter<E, ID> where(ID pk) {
            this.where = QuerydslDao.this.pkValueEqExpr(pk);
            return this;
        }

        @Override
        public Dao.UpdateEntityExecuter<E, ID> set(E entity) {
            return new UpdateEntityExecuterImpl(entity, this.where);
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> set(Path<T> column, T value) {
            return new UpdateValueExecuterImpl(this.where).set(column, value);
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> set(Path<T> column, Expression<? extends T> expression) {
            return new UpdateValueExecuterImpl(this.where).set(column, expression);
        }

        @Override
        public <T> Dao.UpdateValueExecuter<E, ID> setNull(Path<T> column) {
            return new UpdateValueExecuterImpl(this.where).setNull(column);
        }
    }

    private class SelectExecuterImpl
    implements Dao.SelectExecuter<E, ID> {
        private IncludeColumns includeColumns;
        private ExcludeColumns excludeColumns;
        private BooleanExpression where;
        private OrderSpecifier<?>[] orderBys;
        private Path<?>[] groupByColumns;
        private Predicate[] havings;
        private Long offset;
        private Long limit;

        private SelectExecuterImpl() {
        }

        private SelectExecuterImpl(IncludeColumns includeColumns) {
            this.includeColumns = includeColumns;
            this.excludeColumns = null;
        }

        private SelectExecuterImpl(ExcludeColumns excludeColumns) {
            this.includeColumns = null;
            this.excludeColumns = excludeColumns;
        }

        @Override
        public Dao.SelectExecuter<E, ID> where(BooleanExpression where) {
            this.where = where;
            return this;
        }

        @Override
        public Dao.SelectExecuter<E, ID> where(ID pk) {
            this.where = QuerydslDao.this.pkValueEqExpr(pk);
            return this;
        }

        @Override
        public Dao.SelectExecuter<E, ID> orderBy(OrderSpecifier<?> ... orderBys) {
            this.orderBys = orderBys;
            return this;
        }

        @Override
        public Dao.SelectExecuter<E, ID> groupBy(Path<?> ... columns) {
            this.groupByColumns = columns;
            return this;
        }

        @Override
        public Dao.SelectExecuter<E, ID> having(Predicate ... havings) {
            this.havings = havings;
            return this;
        }

        @Override
        public Dao.SelectExecuter<E, ID> paging(long offset, long limit) {
            this.offset = offset;
            this.limit = limit;
            return this;
        }

        @Override
        public Dao.SelectExecuter<E, ID> offset(long offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public Dao.SelectExecuter<E, ID> limit(long limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public List<E> fetch() {
            if (this.excludeColumns == null) {
                return QuerydslDao.this.fetch(this.where, this.includeColumns, this.createPaging(), this.createGroupBy(), this.orderBys);
            }
            return QuerydslDao.this.fetch(this.where, this.excludeColumns, this.createPaging(), this.createGroupBy(), this.orderBys);
        }

        @Override
        public E fetchFirst() {
            TablePathBase projection = QuerydslDao.this.qvar;
            if (this.excludeColumns != null) {
                projection = QuerydslDao.this.listColumns(this.excludeColumns);
            }
            return QuerydslDao.this.fetchFirst((Expression)projection, this.where, this.createGroupBy(), this.orderBys);
        }

        @Override
        public E fetchOne() {
            TablePathBase projection = QuerydslDao.this.qvar;
            if (this.excludeColumns != null) {
                projection = QuerydslDao.this.listColumns(this.excludeColumns);
            }
            return QuerydslDao.this.fetchOne((Expression)projection, this.where, this.createGroupBy());
        }

        private Paging createPaging() {
            if (this.limit == null && this.offset == null) {
                return null;
            }
            if (this.offset == null) {
                return Paging.limit(this.limit);
            }
            if (this.limit == null) {
                return Paging.offset(this.offset);
            }
            return Paging.of(this.offset, this.limit);
        }

        private GroupBy createGroupBy() {
            if (this.groupByColumns == null) {
                return null;
            }
            return GroupBy.of(this.groupByColumns).having(this.havings);
        }
    }
}

