/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.querydsl;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.PrimaryKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.querydsl.EntityProjection;
import net.apexes.commons.querydsl.ExcludeColumns;
import net.apexes.commons.querydsl.IncludeColumns;
import net.apexes.commons.querydsl.PathValuePair;
import net.apexes.commons.querydsl.sql.TablePathBase;

public class QuerydslHelper<T, ID extends Serializable> {
    private final TablePathBase<T> qvar;
    private final Class<T> entityClass;
    private final Path<?>[] allPathArr;
    private final Path<ID> pkPath;
    private final Path<?>[] withoutPkPathArr;

    public QuerydslHelper(TablePathBase<T> qvar) {
        this.qvar = qvar;
        this.entityClass = qvar.getType();
        PrimaryKey primaryKey = qvar.getPrimaryKey();
        if (primaryKey == null) {
            throw new RuntimeException(this.entityClass.getName() + " primary key must be the only.");
        }
        List pkPaths = primaryKey.getLocalColumns();
        if (pkPaths.size() != 1) {
            throw new RuntimeException(this.entityClass.getName() + " primary key must be the only.");
        }
        this.pkPath = (Path)pkPaths.get(0);
        ArrayList<Path> withoutPkPaths = new ArrayList<Path>();
        LinkedHashMap<String, Path> pathMap = new LinkedHashMap<String, Path>();
        for (Path path : qvar.getColumns()) {
            if (this.pkPath != path) {
                withoutPkPaths.add(path);
            }
            pathMap.put(this.fieldName(path), path);
        }
        if (pathMap.isEmpty()) {
            throw new RuntimeException(this.entityClass.getName() + " paths is empty");
        }
        this.withoutPkPathArr = withoutPkPaths.toArray(new Path[0]);
        this.allPathArr = ((HashMap)pathMap).values().toArray(new Path[0]);
    }

    public TablePathBase<T> getQvar() {
        return this.qvar;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public Path<ID> pkPath() {
        return this.pkPath;
    }

    public Path<?>[] allPaths() {
        return this.allPathArr;
    }

    public Path<?>[] withoutPkColumns() {
        return this.withoutPkPathArr;
    }

    public boolean isEntityColumn(Path<?> path) {
        return this.qvar.getColumns().contains(path);
    }

    public boolean isPkColumn(Path<?> path) {
        return this.pkPath.equals(path);
    }

    public <E> E getValue(T entity, Path<E> path) {
        String fieldName = this.fieldName(path);
        try {
            return (E)this.qvar.getFieldValue(entity, fieldName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(T entity, Path<?> path, Object value) {
        String fieldName = this.fieldName(path);
        try {
            this.qvar.setFieldValue(entity, fieldName, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object[] entityValues(T entity) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Path<?> path : this.allPathArr) {
                String fieldName = this.fieldName(path);
                list.add(this.qvar.getFieldValue(entity, fieldName));
            }
            return list.toArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String fieldName(Path<?> path) {
        return path.getMetadata().getName();
    }

    public String columnName(Path<?> path) {
        return this.qvar.getColumnName(path);
    }

    public String tableName() {
        return this.qvar.getTableName();
    }

    public BooleanExpression pkValueEqExpr(ID pk) {
        Checks.verifyNotNull(pk, (String)"pk");
        return ((SimpleExpression)this.pkPath).eq(pk);
    }

    public EntityProjection<T, ID> createtProjection(IncludeColumns includeColumns) {
        return new EntityProjection(this, this.qvar, includeColumns.getIncludeColumns());
    }

    public EntityProjection<T, ID> createtProjection(ExcludeColumns excludeColumns) {
        Map<Path<?>, Path<?>> excludeColumnsBag = excludeColumns.getExcludeColumnsBag();
        ArrayList includeColumns = new ArrayList();
        for (Path<?> col : this.allPathArr) {
            if (excludeColumnsBag.containsKey(col)) continue;
            includeColumns.add(col);
        }
        Path[] cols = includeColumns.toArray(new Path[0]);
        return new EntityProjection(this, this.qvar, cols);
    }

    public PathValuePair<T, ID> createPathValuePair(T entity, Path<?>[] paths) {
        return new PathValuePair(this, entity, paths);
    }

    public PathValuePair<T, ID> createPathValuePair(T entity, IncludeColumns includeColumns) {
        return this.createPathValuePair(entity, includeColumns.getIncludeColumns());
    }

    public PathValuePair<T, ID> createPathValuePair(T entity, ExcludeColumns excludeColumns) {
        Map<Path<?>, Path<?>> excludeColumnsBag = excludeColumns.getExcludeColumnsBag();
        ArrayList includeColumns = new ArrayList();
        for (Path<?> col : this.allPathArr) {
            if (excludeColumnsBag.containsKey(col)) continue;
            includeColumns.add(col);
        }
        Path[] columns = includeColumns.toArray(new Path[0]);
        return this.createPathValuePair(entity, columns);
    }
}

